<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('student_intern_places', function (Blueprint $table) {
            $table->id();
            $table->integer('student_id');
            $table->integer('internship_place_id');
            $table->date('start_date');
            $table->tinyInteger('is_intern_pass')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('student_intern_places');
    }
};
