<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('videoes', function (Blueprint $table) {
            $table->id();
            $table->string('name', 255);
            $table->text('video');
            $table->text('video_id');
            $table->text('cover');
            $table->text('description')->nullable();
            $table->tinyInteger('status');
            $table->unsignedInteger('album_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('videoes');
    }
};
