<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('classes', function (Blueprint $table) {
            if (!Schema::hasColumn('classes', 'class_cost')) {
                $table->double('class_cost')->after('url_google_sheet_view')->default(0)->nullable();
            }
            if (!Schema::hasColumn('classes', 'supplies_cost')) {
                $table->double('supplies_cost')->after('class_cost')->default(0)->nullable();
            }
            if (!Schema::hasColumn('classes', 'total_cost')) {
                $table->double('total_cost')->after('supplies_cost')->default(0)->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('classes', function (Blueprint $table) {
            //
        });
    }
};
