<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('students', function (Blueprint $table) {
            if (!Schema::hasColumn('students', 'status')) {
                $table->tinyInteger('status')->after('noted')->default(1)->nullable();
            }
            if (!Schema::hasColumn('students', 'current_working_place')) {
                $table->longText('current_working_place')->after('noted')->nullable();
            }
            if (!Schema::hasColumn('students', 'working_experience')) {
                $table->longText('working_experience')->after('noted')->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('students', function (Blueprint $table) {
            //
        });
    }
};
