<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('lessons', function (Blueprint $table) {
            if (!Schema::hasColumn('lessons', 'practice_duration_type')) {
                $table->string('practice_duration_type')->after('practice_hour')->default('h')->comment('h: hour, mn:minute')->nullable();
            }
            if (!Schema::hasColumn('lessons', 'theory_duration_type')) {
                $table->string('theory_duration_type')->after('theory_hour')->default('h')->comment('h: hour, mn:minute')->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('lessons', function (Blueprint $table) {
            //
        });
    }
};