<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('students', function (Blueprint $table) {
            if (!Schema::hasColumn('students', 'password')) {
                $table->string('password')->nullable()->after('email');
            }
            if (!Schema::hasColumn('students', 'approval_status')) {
                $table->string('approval_status')->default('approved')->nullable()->after('status')->comment('pending, approved, rejected');
            }
            if (!Schema::hasColumn('students', 'role')) {
                $table->string('role')->nullable()->after('approval_status')->default('student');
            }
            if (!Schema::hasColumn('students', 'remember_token')) {
                $table->rememberToken();
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('students', function (Blueprint $table) {
            if(Schema::hasColumn('students', 'password')) {
                $table->dropColumn('password');
            }
            if(Schema::hasColumn('students', 'approval_status')) {
                $table->dropColumn('approval_status');
            }
            if(Schema::hasColumn('students', 'role')) {
                $table->dropColumn('role');
            }
            if(Schema::hasColumn('students', 'remember_token')) {
                $table->dropRememberToken();
            }
        });
    }
};
