<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <link rel="shortcut icon" href="{{ asset('images/logo/LICE_serge_comtesse_cambodia_black.png') }}" type="image/x-icon">
    <title>LICE SYSTEM</title>
    {!! HTML::style('admin-public/css/app.css') !!}
    {!! HTML::style('admin-public/css/select2Customize.css') !!}
    {!! HTML::style('admin-public/css/view-info.css') !!}
    {!! HTML::script('admin-public/js/app.js') !!}
    <script src="{!! asset('admin-public/js/defer.js') !!}" defer></script>
    <link rel="stylesheet" href="{{ asset('plugin/toastr.min.css') }}">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="{{ asset('plugin/toastr.min.js') }}"></script>
    <script src="{{ asset('admin-public/js/tinymce/tinymce.min.js') }}" referrerpolicy="origin"></script>
    <script src="{{ asset('admin-public/js/icheck.min.js') }}"></script>
    <script src="https://cdn.jsdelivr.net/npm/feather-icons/dist/feather.min.js"></script>
</head>

<body>
    @yield('index')
    @include('admin::components.toast')
    <script lang="ts">
         $(document).ready(function() {
             @if (Session::has('success'))
                 Toast({
                     title: 'Success Message',
                     message: '{!! Session::get('success') !!}',
                     status: 'success',
                     duration: 5000,
                 });
             @elseif(Session::has('error'))
                 Toast({
                     title: 'Error Message',
                     message: '{!! Session::get('error') !!}',
                     status: 'danger',
                     duration: 5000,
                 });
             @elseif(Session::has('warning'))
                 Toast({
                     title: 'Warning Message',
                     message: '{!! Session::get('warning') !!}',
                     status: 'warning',
                     duration: 5000,
                 });
             @endif
        });
    </script>
    @yield('script')
    {!! HTML::script('admin-public/js/body.js') !!}
</body>

</html>
