@extends('admin::shared.layout')
@section('layout')
    <div class="form-admin">
        <div class="form-bg"></div>
        <form id="form" class="form-wrapper" action="{!! route('admin-branch-save', request('id')) !!}" method="POST" enctype="multipart/form-data">
            <div class="form-header">
                <h3>
                    <i data-feather="arrow-left" s-click-link="{!! route('admin-branch-list', 1) !!}"></i>
                    {!! request('id') ? 'Update' : 'Create' !!} Branch
                </h3>
            </div>
            {{ csrf_field() }}
            <div class="form-body">
                {{-- <div class="row">
                    <div class="form-row">
                        <label for="">Branch</label>
                        <Select name="parent_id">
                            <option value="">Select branch...</option>
                            @foreach ($branches as $branch)
                                <option value="{{ $branch->id }}"
                                    {{ request('id') && $data->branch_code->parent_id == $branch->id ? 'selected' : old('parent_id') }}>
                                    {{ $branch->name }}</option>
                            @endforeach
                        </Select>
                        @error('parent_id')
                            <span class="error">{{ $message }}</span>
                        @enderror
                    </div>
                </div> --}}
                <div class="row-2">
                    <div class="form-row">
                        <label for="">Name <span>*</span></label>
                        <input type="text" name="name" id=""
                            value="{{ request('id') ? $data->name : old('name') }}">
                        @error('name')
                            <span class="error">{{ $message }}</span>
                        @enderror
                    </div>
                    <div class="form-row">
                        <label for="">Phone <span>*</span></label>
                        <input type="text" name="phone" id=""
                            value="{{ request('id') ? $data->phone : old('phone') }}">
                        @error('phone')
                            <span class="error">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                <div class="row-2">
                    <div class="form-row">
                        <label for="">Email</label>
                        <input type="text" name="email" id=""
                            value="{{ request('id') ? $data->email : old('email') }}">
                        @error('email')
                            <span class="error">{{ $message }}</span>
                        @enderror
                    </div>
                    <div class="form-row">
                        <label for="">Address <span>*</span></label>
                        <input type="text" name="address" id=""
                            value="{{ request('id') ? $data->address : old('address') }}">
                        @error('address')
                            <span class="error">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                <div class="row-2">
                    <div class="form-row">
                        <label for="">Website</label>
                        <input type="text" name="website" id=""
                            value="{{ request('id') ? $data->website : old('website') }}">
                        @error('website')
                            <span class="error">{{ $message }}</span>
                        @enderror
                    </div>
                    <div class="form-row">
                        <label>Status<span>*</span></label>
                        <select name="status">
                            <option value="1" {!! (request('id') && $data->status == 1) || old('status') == 1 ? 'selected' : '' !!}>@lang('user.form.status.active')</option>
                            <option value="2" {!! (request('id') && $data->status == 2) || old('status') == 2 ? 'selected' : '' !!}>@lang('user.form.status.disable')</option>
                        </select>
                    </div>
                </div>
                <div class="row-2">
                    <div class="form-row">
                        <label>@lang('user.form.profile.label')</label>
                        <div class="form-select-photo image">
                            <div class="select-photo {!! request('id') && isset($data) && $data->logo != null ? 'active' : '' !!}">
                                <div class="icon">
                                    <i data-feather="image"></i>
                                </div>
                                <div class="title">
                                    <span>@lang('user.form.profile.placeholder')</span>
                                </div>
                            </div>
                            <div class="image-view {!! request('id') && isset($data) && $data->logo != null ? 'active' : '' !!}">
                                <img src="{!! request('id') && isset($data) && $data->logo != null ? asset('file_manager' . $data->logo) : null !!}"
                                    onerror="(this).src='{{ asset('images/logo/default.png') }}'" alt="">
                            </div>
                            <input type="text" name="image" s-click-fn="selectImage(event)" autocomplete="off"
                                role="presentation">
                            <input type="hidden" name="tmp_file" value="{!! request('id') && isset($data) && $data->logo != null ? $data->logo : '' !!}">
                        </div>
                    </div>
                </div>
                <div class="form-button">
                    <button type="submit" color="primary">
                        <i data-feather="save"></i>
                        <span>Submit</span>
                    </button>
                    <button color="danger" type="button" s-click-link="{!! route('admin-branch-list', 1) !!}">
                        <i data-feather="x"></i>
                        <span>Cancel</span>
                    </button>
                </div>
            </div>
            <div class="form-footer"></div>
        </form>
    </div>
    @include('admin::file-manager.popup')
@stop

@section('script')
    <script lang="ts">
        $(document).ready(function() {
            $validator("#form", {
                name: {
                    required: true
                },
                phone: {
                    required: true
                },
                address: {
                    required: true
                },
                status: {
                    required: true
                },
            });
        });

        function selectImage(e) {
            fileManager({
                multiple: false,
                afterClose: (data, basePath) => {
                    if (data?.length > 0) {
                        const parent = e.target.closest('.form-select-photo');
                        e.target.value = data[0].path;
                        parent
                            .querySelector('.select-photo')
                            .classList.add('active');
                        parent
                            .querySelector('.image-view')
                            .classList
                            .add('active');
                        parent
                            .querySelector('.image-view')
                            .childNodes[0]
                            .nextElementSibling
                            .setAttribute('src', basePath + data[0].path);
                    }
                }
            })
        }
    </script>
    <script>
        const header = {
            headers: {
                "Content-Type": "application/x-www-form-urlencoded;charset=utf-8",
                Accept: "application/json",
            },
            responseType: "json",
        };
        document.addEventListener('alpine:init', () => {
            Alpine.data("xService", () => ({}));
        });
    </script>
@stop
