@extends('admin::shared.layout')
@section('layout')
    <div class="form-admin" x-data="create_classes">
        <div class="form-bg"></div>
        <form id="form" class="form-wrapper" action="{!! route('admin-class-save', request('id')) !!}" method="POST" enctype="multipart/form-data">
            <div class="form-header">
                <h3>
                    <i data-feather="arrow-left" s-click-link="{!! route('admin-class-list', 1) !!}"></i>
                    {!! request('id') ? 'Update Class' : 'Create Class' !!}
                </h3>
            </div>
            {{ csrf_field() }}
            <div class="form-body">
                <div class="row-2">
                    <div class="form-row">
                        <label>Select Class Type <span>*</span></label>
                        <select name="class_type_id">
                            <option value="">Select class type</option>
                            @foreach ($class_type as $ct)
                                <option value="{!! $ct->id !!}" {!! (request('id')
                                        ? ($ct->id == $data->class_type_id
                                            ? 'selected'
                                            : '')
                                        : old('class_type_id') == $ct->id)
                                    ? 'selected'
                                    : '' !!}>{!! $ct->name !!}
                                </option>
                            @endforeach
                        </select>
                        @error('class_type_id')
                            <span class="error">{!! $message !!}</span>
                        @enderror
                    </div>
                    <div class="form-row">
                        <label>Select Class Level <span>*</span></label>
                        <select name="class_level_id">
                            <option value="">Select class level</option>
                            @foreach ($class_level as $cl)
                                <option value="{!! $cl->id !!}" {!! (request('id')
                                        ? ($cl->id == $data->class_level_id
                                            ? 'selected'
                                            : '')
                                        : old('class_level_id') == $cl->id)
                                    ? 'selected'
                                    : '' !!}>{!! $cl->name !!}
                                </option>
                            @endforeach
                        </select>
                        @error('class_level_id')
                            <span class="error">{!! $message !!}</span>
                        @enderror
                    </div>
                </div>
                <div class="row-2">
                    <div class="form-row">
                        <label>Select Class Status <span>*</span></label>
                        <select name="class_status_id">
                            <option value="">Select class status</option>
                            @foreach ($class_status as $cs)
                                <option value="{!! $cs->id !!}" {!! (request('id')
                                        ? ($cs->id == $data->class_status_id
                                            ? 'selected'
                                            : '')
                                        : old('class_status_id') == $cs->id)
                                    ? 'selected'
                                    : '' !!}>{!! $cs->name !!}
                                </option>
                            @endforeach
                        </select>
                        @error('class_status_id')
                            <span class="error">{!! $message !!}</span>
                        @enderror
                    </div>
                    <div class="form-row">
                        <label>Select Shift <span>*</span></label>
                        <select name="shift_id">
                            <option value="">Select class shift</option>
                            @foreach ($shift as $sh)
                                <option value="{!! $sh->id !!}" {!! (request('id')
                                        ? ($sh->id == $data->shift_id
                                            ? 'selected'
                                            : '')
                                        : old('shift_id') == $sh->id)
                                    ? 'selected'
                                    : '' !!}>{!! $sh->name !!}
                                </option>
                            @endforeach
                        </select>
                        @error('shift_id')
                            <span class="error">{!! $message !!}</span>
                        @enderror
                    </div>
                </div>
                <div class="row-2">
                    <div class="form-row">
                        <label>Select Staff <span>*</span></label>
                        <select name="staff_id">
                            <option value="">Select staff</option>
                            @foreach ($staff as $st)
                                <option value="{!! $st->id !!}" {!! (request('id')
                                        ? ($st->id == $data->staff_id
                                            ? 'selected'
                                            : '')
                                        : old('staff_id') == $st->id)
                                    ? 'selected'
                                    : '' !!}>{!! $st->full_name !!}
                                </option>
                            @endforeach
                        </select>
                        @error('staff_id')
                            <span class="error">{!! $message !!}</span>
                        @enderror
                    </div>
                    <div class="form-row">
                        <label>Class Code <span>*</span></label>
                        <input type="text" name="class_code" value="{!! request('id') ? $data->class_code : old('class_code') !!}" placeholder="Class Code" />
                        @error('class_code')
                            <span class="error">{!! $message !!}</span>
                        @enderror
                    </div>
                </div>
                <div class="row-2">
                    <div class="form-row">
                        <label>Generation <span>*</span></label>
                        <input type="text" id="generation" name="generation" placeholder="Generation"
                            value="{!! request('id') ? $data->generation : old('generation') !!}" />
                        @error('generation')
                            <span class="error">{!! $message !!}</span>
                        @enderror
                    </div>
                    <div class="form-row">
                        <label>Group <span>*</span></label>
                        <input type="text" id="group" name="group" value="{!! request('id') ? $data->group : old('group') !!}"
                            placeholder="Group">
                        @error('group')
                            <span class="error">{!! $message !!}</span>
                        @enderror
                    </div>
                </div>
                <div class="row-2">
                    <div class="form-row">
                        <label>Period Duration (Day)<span>*</span></label>
                        <input type="text" id="duration" name="period_duration" placeholder="Period Duratioin"
                            value="{!! request('id') ? $data->period_duration : old('period_duration') !!}" />
                        @error('period_duration')
                            <span class="error">{!! $message !!}</span>
                        @enderror
                    </div>
                    <div class="row-2">
                        <div class="form-row">
                            <label>Start Date <span>*</span></label>
                            <input type="text" id="start_date" name="start_date" placeholder="Start Data"
                                value="{!! request('id') ? $data->start_date : old('start_date') !!}" readonly>
                            @error('start_date')
                                <span class="error">{!! $message !!}</span>
                            @enderror
                        </div>
                        <div class="form-row">
                            <label>End Date <span>*</span></label>
                            <input type="text" id="end_date" name="end_date" placeholder="End Date"
                                value="{!! request('id') ? $data->end_date : old('end_date') !!}" readonly>
                            @error('end_date')
                                <span class="error">{!! $message !!}</span>
                            @enderror
                        </div>
                    </div>
                </div> 
                <div class="row-3">
                    <div class="form-row">
                        <label>Class Cost </label>
                        <input @input="calcTotalCost()" type="text" name="class_cost" value="{!! request('id') ? $data->class_cost : old('class_cost') !!}"
                            placeholder="0" id="class_cost">
                        @error('class_cost')
                            <span class="error">{!! $message !!}</span>
                        @enderror
                    </div>
                    <div class="form-row">
                        <label>Supplies Cost ($)</label>
                        <input @input="calcTotalCost()" type="text" name="supplies_cost" value="{!! request('id') ? $data->supplies_cost : old('supplies_cost') !!}"
                            placeholder="0" id="supplies_cost">
                        @error('supplies_cost')
                            <span class="error">{!! $message !!}</span>
                        @enderror
                    </div> 
                    <div class="form-row">
                        <label>Total Cost ($)</label>
                        <input type="text" name="total_cost" value="{!! request('id') ? $data->total_cost : old('total_cost') !!}"
                            placeholder="0" id="total_cost" readonly>
                        @error('total_cost')
                            <span class="error">{!! $message !!}</span>
                        @enderror
                    </div>
                </div> 
                <div class="row">
                    <div class="form-row">
                        <label>URL Google Sheet Edit Embed ($)</label>
                        <textarea name="url_google_sheet_edit" placeholder="Enter Google Sheet link that can edit">{!! request('id') ? $data->url_google_sheet_edit : old('url_google_sheet_edit') !!}</textarea>
                        @error('url_google_sheet_edit')
                            <span class="error">{!! $message !!}</span>
                        @enderror
                    </div>
                </div>
                <div class="row">
                    <div class="form-row">
                        <label>URL Google Sheet View Embed </label>
                        <textarea name="url_google_sheet_view" placeholder="Enter Google Sheet link that can view only">{!! request('id') ? $data->url_google_sheet_view : old('url_google_sheet_view') !!}</textarea>
                        @error('url_google_sheet_view')
                            <span class="error">{!! $message !!}</span>
                        @enderror
                    </div>
                </div>
                <div class="form-button">
                    <button type="submit" color="primary">
                        <i data-feather="save"></i>
                        <span>Submit</span>
                    </button>
                    <button color="danger" type="button" s-click-link="{!! route('admin-class-list', 1) !!}">
                        <i data-feather="x"></i>
                        <span>Cancel</span>
                    </button>
                </div>
            </div>
            <div class="form-footer"></div>
        </form>
    </div>
    @include('admin::file-manager.popup')
@stop

@section('script')
    <script lang="ts">
        Alpine.data('create_classes', () => ({
            init() {
                this.onKeyUp();
                if(!@json(request('id'))){
                    $('#total_cost').val(0);
                }
            },
            onKeyUp() {
                $('#group').keyup(function() {
                    this.value = this.value.replace(/[^0-9]/g, '');
                    if (this.value.length > 15) {
                        this.value = this.value.slice(0, 15);
                    }
                });
                $('#generation').keyup(function() {
                    this.value = this.value.replace(/[^0-9]/g, '');
                    if (this.value.length > 15) {
                        this.value = this.value.slice(0, 15);
                    }
                });
                $('#duration').keyup(function() {
                    this.value = this.value.replace(/[^0-9]/g, '');
                    if (this.value.length > 15) {
                        this.value = this.value.slice(0, 15);
                    }
                });
                $('#class_cost').keyup(function() {
                    this.value = this.value.replace(/[^0-9.]/g, '');
                    if (this.value.length > 15) {
                        this.value = this.value.slice(0, 15);
                    }
                    if (this.value < 0) {
                        this.value = 0;
                    }

                    // if typing dot more than 0 then add 0 before dot and remove dot after 2 number
                    if (this.value.split('.').length > 1) {
                        if (this.value.split('.')[0] == '') {
                            this.value = '0' + this.value;
                        }

                        this.value = this.value.split('.')[0] + '.' + this.value.split('.')[1]
                            .slice(0, 2);
                    }

                    // value as float
                    if (this.value.split('.').length > 0) {
                        if (this.value.split('.')[1]) {
                            this.value = this.value.split('.')[0] + '.' + this.value.split('.')[1]
                                .slice(0, 2);
                        }
                    }
                });
                $('#supplies_cost').keyup(function() {
                    this.value = this.value.replace(/[^0-9.]/g, '');
                    if (this.value.length > 15) {
                        this.value = this.value.slice(0, 15);
                    }
                    if (this.value < 0) {
                        this.value = 0;
                    }

                    // if typing dot more than 0 then add 0 before dot and remove dot after 2 number
                    if (this.value.split('.').length > 1) {
                        if (this.value.split('.')[0] == '') {
                            this.value = '0' + this.value;
                        }

                        this.value = this.value.split('.')[0] + '.' + this.value.split('.')[1]
                            .slice(0, 2);
                    }

                    // value as float
                    if (this.value.split('.').length > 0) {
                        if (this.value.split('.')[1]) {
                            this.value = this.value.split('.')[0] + '.' + this.value.split('.')[1]
                                .slice(0, 2);
                        }
                    }
                });
            },
            calcTotalCost(){
                let classCost = parseFloat($('#class_cost').val());
                if(classCost == '' || classCost == null){
                    classCost = 0;
                }
                let suppliesCost = parseFloat($('#supplies_cost').val());
                if(suppliesCost == '' || suppliesCost == null){
                    suppliesCost = 0;
                }
                if(isNaN(classCost) || isNaN(suppliesCost)){
                    if(isNaN(classCost) && !isNaN(suppliesCost)){
                        $('#total_cost').val(suppliesCost);
                    }else if(isNaN(suppliesCost) && !isNaN(classCost)){
                        $('#total_cost').val(classCost);
                    }else if(isNaN(suppliesCost) && isNaN(classCost)){
                        $('#total_cost').val(0);
                    }
                }else{
                    let totalCost = parseFloat(classCost) + parseFloat(suppliesCost);
                    $('#total_cost').val(totalCost);
                }
            }
        }));
        $(document).ready(function() {
            $validator("#form", {
                class_type_id: {
                    required: true,
                },
                class_level_id: {
                    required: true,
                },
                class_status_id: {
                    required: true,
                },
                shift_id: {
                    required: true,
                },
                staff_id: {
                    required: true,
                },
                class_code: {
                    required: true,
                },
                generation: {
                    required: true,
                },
                group: {
                    required: true,
                },
                period_duration: {
                    required: true,
                },
                start_date: {
                    required: true,
                },
                end_date: {
                    required: true,
                },
            });

            $("#start_date").datepicker({
                changeYear: true,
                gotoCurrent: true,
                yearRange: '-50:',
                dateFormat: "yy-mm-dd",
                onSelect: (select) => {
                    $('#end_date').datepicker('option', 'minDate', select)
                }
            });

            $("#end_date").datepicker({
                changeYear: true,
                gotoCurrent: true,
                yearRange: '-50:',
                dateFormat: "yy-mm-dd",
                minDate: $("#start_date").val(),
            });
        });
    </script>
@stop
