@extends('admin::shared.layout')
@section('layout')
    <div class="content-wrapper">
        <div class="header">
            @include('admin::shared.header', ['header_name' => 'Class Management'])
            <div class="header-tab">
                <div class="header-tab-wrapper">
                    <div class="menu-row">
                        <div class="menu-item {!! Request::is('admin/class/list/1') ? 'active' : '' !!}" s-click-link="{!! route('admin-class-list', 1) !!}">
                            All</div>
                    </div>
                </div>
                <div class="header-action-button">
                    <form class="filter" action="{!! url()->current() !!}" method="GET">
                        <div class="form-row" style="min-width: 175px;">
                            <select name="class_cost" style="width: 100%" class="bg-transparent">
                                <option value="">Class Cost Type</option>
                                <option value="free" {{ request('class_cost') == 'free' ? 'selected' : '' }}>Free</option>
                                <option value="cost" {{ request('class_cost') == 'cost' ? 'selected' : '' }}>Cost</option>
                            </select>
                        </div>
                        <div class="form-row" style="min-width: 175px;">
                            <select name="supplies_cost" style="width: 100%" class="bg-transparent">
                                <option value="">Supplies Cost Type</option>
                                <option value="free" {{ request('supplies_cost') == 'free' ? 'selected' : '' }}>Free</option>
                                <option value="cost" {{ request('supplies_cost') == 'cost' ? 'selected' : '' }}>Cost</option>
                            </select>
                        </div>
                        <div class="form-row">
                            <input type="text" name="keyword" placeholder="Class filter search"
                                value="{!! request('keyword') !!}">
                            <i data-feather="filter"></i>
                        </div>
                        <button mat-flat-button type="submit" class="btn-create bg-success">
                            <i data-feather="search"></i>
                            <span>Search</span>
                        </button>
                    </form>
                    @can('class-create')
                        <button class="btn-create" s-click-link="{!! route('admin-class-create') !!}">
                            <i data-feather="plus-circle"></i>
                            <span>Create New Class</span>
                        </button>
                    @endcan
                    <button s-click-link="{!! url()->current() !!}">
                        <i data-feather="refresh-ccw"></i>
                        <span>Reload</span>
                    </button>
                </div>
            </div>
        </div>
        <div class="content-body">
            @include('admin::pages.class.table')
        </div>
    </div>
@stop
@section('script')
    <script></script>
@stop
