<div id="student-list" class="form-body p-3 mt-3">
    <div class="d-flex mb-3">
        <div class="btn-create bg-primary mr-2 cursor-pointer d-flex justify-content-center align-items-center p-2"
            style="border-radius: 5px" @click="printStudentCard()">
            <span class="text-light">{!! strtoupper('Student Card') !!}</span>
        </div>
        <div class="btn-create bg-primary mr-2 cursor-pointer d-flex justify-content-center align-items-center p-2"
            style="border-radius: 5px" @click="printStudentCertificate()">
            <span class="text-light">{!! strtoupper('Certificate') !!}</span>
        </div>
    </div>
    <template x-if="card">
        <form action="{{route('admin-class-student-card', request('class_id'))}}" method="GET">
            <div class="row">
                <div class="form-row d-flex justify-content-between flex-row">
                    <div class="d-flex">
                        <div class="btn-create bg-primary mr-2 cursor-pointer d-flex justify-content-center align-items-center p-3"
                            style="border-radius: 5px" @click="toggleAllCheckboxes()">
                            <span class="text-light">{!! strtoupper('Checked all') !!}</span>
                        </div>
                    </div>
                    <div class="d-flex">
                        <button class="btn-create bg-primary mr-2" type="submit">
                            <span class="text-light">
                                Print Student Card
                            </span>
                        </button>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="table">
                    <div class="table-wrapper">
                        <div class="table-header bg-black text-light">
                            <div class="row table-row-7">
                                <span class="font-sm">{!! strtoupper('select') !!}</span>
                            </div>
                            <div class="row table-row-6">
                                <span class="font-sm">{!! strtoupper('STU. ID') !!}</span>
                            </div>
                            <div class="row table-row-15">
                                <span class="font-sm">{!! strtoupper('Student name KH') !!}</span>
                            </div>
                            <div class="row table-row-15">
                                <span class="font-sm">{!! strtoupper('student name') !!}</span>
                            </div>
                            <div class="row table-row-15">
                                <span class="font-sm">{!! strtoupper('Tel.') !!}</span>
                            </div>
                            <div class="row table-row-10">
                                <span class="font-sm">{!! strtoupper('Gender') !!}</span>
                            </div>
                            <div class="row table-row-10">
                                <span class="font-sm">{!! strtoupper('Date of Birth') !!}</span>
                            </div>
                            <div class="row table-row-12">
                                <span class="font-sm">{!! strtoupper('other') !!}</span>
                            </div>
                            <div class="row table-row-10">
                                <span class="font-sm">{!! strtoupper('joined on') !!}</span>
                            </div>
                        </div>
                        <div class="table-body overflow-auto">
                            @if (count($data) > 0)
                            @foreach($data->sortBy('id') as $student)
                            <div class="column">
                                <div class="row table-row-7">
                                    <span>
                                        <input class="item-select-input" type="checkbox" name="student_id[]"
                                            value="{!! $student->id !!}" x-model="selectStudents" />
                                    </span>
                                </div>
                                <div class=" row table-row-6">
                                    <span>
                                        {!! $student->id ?? '--' !!}
                                    </span>
                                </div>
                                <div class="row table-row-15">
                                    <span>
                                        {!! $student->name_khmer ?? '--' !!}
                                    </span>
                                </div>
                                <div class="row table-row-15">
                                    <span>
                                        {!! $student->name_latin ?? '--' !!}
                                    </span>
                                </div>
                                <div class="row table-row-15">
                                    <span>
                                        {!! $student->phone ?? '--' !!}
                                    </span>
                                </div>
                                <div class="row table-row-10">
                                    <span>
                                        {!! $student->gender ?? '--' !!}
                                    </span>
                                </div>
                                <div class="row table-row-10">
                                    <span>
                                        {!! $student->dob ?? '--' !!}
                                    </span>
                                </div>
                                <div class="row table-row-12">
                                    <span>
                                        {!! $student->note ?? '--' !!}
                                    </span>
                                </div>
                                <div class="row table-row-10">
                                    <span>
                                        {!! $student->pivot->created_at ?? '--' !!}
                                    </span>
                                </div>
                            </div>
                            @endforeach
                            @else
                            <div class="column">
                                <div class="row table-row-100">
                                    <span class="text-danger">
                                        {{strtoupper('no data!')}}
                                    </span>
                                </div>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </template>
    <template x-if="certificate">
        <form action="{{route('admin-class-student-card', request('class_id'))}}" method="GET">
            <div class="row">
                <div class="form-row d-flex justify-content-between flex-row">
                    <div class="d-flex">
                        <div class="btn-create bg-primary mr-2 cursor-pointer d-flex justify-content-center align-items-center p-3"
                            style="border-radius: 5px" @click="toggleAllCheckboxes()">
                            <span class="text-light">{!! strtoupper('Checked all') !!}</span>
                        </div>
                    </div>
                    <div class="d-flex">
                        <button class="btn-create bg-primary mr-2" type="submit">
                            <span class="text-light">
                                Print Student Certificate
                            </span>
                        </button>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="table">
                    <div class="table-wrapper">
                        <div class="table-header bg-black text-light">
                            <div class="row table-row-7">
                                <span class="font-sm">{!! strtoupper('select') !!}</span>
                            </div>
                            <div class="row table-row-6">
                                <span class="font-sm">{!! strtoupper('STU. ID') !!}</span>
                            </div>
                            <div class="row table-row-15">
                                <span class="font-sm">{!! strtoupper('Student name KH') !!}</span>
                            </div>
                            <div class="row table-row-15">
                                <span class="font-sm">{!! strtoupper('student name') !!}</span>
                            </div>
                            <div class="row table-row-15">
                                <span class="font-sm">{!! strtoupper('Tel.') !!}</span>
                            </div>
                            <div class="row table-row-10">
                                <span class="font-sm">{!! strtoupper('Gender') !!}</span>
                            </div>
                            <div class="row table-row-10">
                                <span class="font-sm">{!! strtoupper('Date of Birth') !!}</span>
                            </div>
                            <div class="row table-row-12">
                                <span class="font-sm">{!! strtoupper('other') !!}</span>
                            </div>
                            <div class="row table-row-10">
                                <span class="font-sm">{!! strtoupper('joined on') !!}</span>
                            </div>
                        </div>
                        <div class="table-body overflow-auto">
                            @if (count($data) > 0)
                            @foreach($data->sortBy('id') as $student)
                            <div class="column">
                                <div class="row table-row-7">
                                    <span>
                                        <input class="item-select-input" type="checkbox" name="student_id[]"
                                            value="{!! $student->id !!}" x-model="selectStudents" />
                                    </span>
                                </div>
                                <div class=" row table-row-6">
                                    <span>
                                        {!! $student->id ?? '--' !!}
                                    </span>
                                </div>
                                <div class="row table-row-15">
                                    <span>
                                        {!! $student->name_khmer ?? '--' !!}
                                    </span>
                                </div>
                                <div class="row table-row-15">
                                    <span>
                                        {!! $student->name_latin ?? '--' !!}
                                    </span>
                                </div>
                                <div class="row table-row-15">
                                    <span>
                                        {!! $student->phone ?? '--' !!}
                                    </span>
                                </div>
                                <div class="row table-row-10">
                                    <span>
                                        {!! $student->gender ?? '--' !!}
                                    </span>
                                </div>
                                <div class="row table-row-10">
                                    <span>
                                        {!! $student->dob ?? '--' !!}
                                    </span>
                                </div>
                                <div class="row table-row-12">
                                    <span>
                                        {!! $student->note ?? '--' !!}
                                    </span>
                                </div>
                                <div class="row table-row-10">
                                    <span>
                                        {!! $student->pivot->created_at ?? '--' !!}
                                    </span>
                                </div>
                            </div>
                            @endforeach
                            @else
                            <div class="column">
                                <div class="row table-row-100">
                                    <span class="text-danger">
                                        {{strtoupper('no data!')}}
                                    </span>
                                </div>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </template>
    <template x-if="show">
        <div>
            <div class="row">
                <div class="form-row d-flex justify-content-between flex-row">
                    <div class="d-flex">
                        <div class="btn-create bg-primary mr-2 cursor-pointer d-flex justify-content-center align-items-center p-3"
                            style="border-radius: 5px" @click="toggleAllCheckboxes()">
                            <span class="text-light">{!! strtoupper('Checked all') !!}</span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="table">
                    <div class="table-wrapper">
                        <div class="table-header bg-black text-light">
                            <div class="row table-row-7">
                                <span class="font-sm">{!! strtoupper('select') !!}</span>
                            </div>
                            <div class="row table-row-6">
                                <span class="font-sm">{!! strtoupper('STU. ID') !!}</span>
                            </div>
                            <div class="row table-row-15">
                                <span class="font-sm">{!! strtoupper('Student name KH') !!}</span>
                            </div>
                            <div class="row table-row-15">
                                <span class="font-sm">{!! strtoupper('student name') !!}</span>
                            </div>
                            <div class="row table-row-15">
                                <span class="font-sm">{!! strtoupper('Tel.') !!}</span>
                            </div>
                            <div class="row table-row-10">
                                <span class="font-sm">{!! strtoupper('Gender') !!}</span>
                            </div>
                            <div class="row table-row-10">
                                <span class="font-sm">{!! strtoupper('Date of Birth') !!}</span>
                            </div>
                            <div class="row table-row-12">
                                <span class="font-sm">{!! strtoupper('other') !!}</span>
                            </div>
                            <div class="row table-row-10">
                                <span class="font-sm">{!! strtoupper('joined on') !!}</span>
                            </div>
                        </div>
                        <div class="table-body overflow-auto">
                            @if (count($data) > 0)
                            @foreach($data->sortBy('id') as $student)
                            <div class="column">
                                <div class="row table-row-7">
                                    <span>
                                        <input class="item-select-input" type="checkbox" name="student_id[]"
                                            value="{!! $student->id !!}" x-model="selectStudents" />
                                    </span>
                                </div>
                                <div class=" row table-row-6">
                                    <span>
                                        {!! $student->id ?? '--' !!}
                                    </span>
                                </div>
                                <div class="row table-row-15">
                                    <span>
                                        {!! $student->name_khmer ?? '--' !!}
                                    </span>
                                </div>
                                <div class="row table-row-15">
                                    <span>
                                        {!! $student->name_latin ?? '--' !!}
                                    </span>
                                </div>
                                <div class="row table-row-15">
                                    <span>
                                        {!! $student->phone ?? '--' !!}
                                    </span>
                                </div>
                                <div class="row table-row-10">
                                    <span>
                                        {!! $student->gender ?? '--' !!}
                                    </span>
                                </div>
                                <div class="row table-row-10">
                                    <span>
                                        {!! $student->dob ?? '--' !!}
                                    </span>
                                </div>
                                <div class="row table-row-12">
                                    <span>
                                        {!! $student->note ?? '--' !!}
                                    </span>
                                </div>
                                <div class="row table-row-10">
                                    <span>
                                        {!! $student->pivot->created_at ?? '--' !!}
                                    </span>
                                </div>
                            </div>
                            @endforeach
                            @else
                            <div class="column">
                                <div class="row table-row-100">
                                    <span class="text-danger">
                                        {{strtoupper('no data!')}}
                                    </span>
                                </div>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </template>
</div>