<template x-if="studentAttendanceOpen">
    <div class="classLogDialogLayout">
        <div class="classLogDialog">
            <div class="overflow-auto h-100 p-4">
                <div class="d-flex flex-row-reverse justify-content-between">
                    <span @click="studentAttendanceOpen=false" class="cursor-pointer btn-close">
                    </span>
                    <h2>
                        {!! strtoupper('Student attendance record detail') !!}
                    </h2>
                </div>
                <div class="w-100 border-bottom mb-3">

                    <h4>Information</h4>
                </div>
                <div class="row-2">
                    <div class="form-row">
                        <label>Student Name</label>
                        <div class="border-1 w-100 p-2">
                            <span x-text="student.name_khmer + ' ' + student.name_latin"></span>
                        </div>
                    </div>
                    <div class="form-row">
                        <label>Class ID</label>
                        <div class="border-1 w-100 p-2">
                            <span>{{request('id')}}</span>
                        </div>
                    </div>
                </div>
                <div class="row-2">
                    <div class="form-row">
                        <label>Student ID</label>
                        <div class="border-1 w-100 p-2">
                            <span x-text="student.id"></span>
                        </div>
                    </div>
                    <div class="form-row">
                        <label>Attend Amount</label>
                        <div class="border-1 w-100 p-2">
                            <span x-text="amount"></span>
                        </div>
                    </div>
                </div>
                <div class="row" class="mb-0">
                    <h4>Attendance Record</h4>
                    <div id="form" class="form-wrapper w-100 border-1 p-2 d-flex align-items-start">
                        {{ csrf_field() }}
                        <div class="row-3 w-100 d-flex justify-content-start">
                            <div class="w-25 mr-2">
                                <button @click="onUpdateStudentAttendance({{request('id')}}, student.id)"
                                    class="btn-create bg-primary mr-2 w-100 d-flex justify-content-center align-content-center">
                                    <span>Insert Attendance</span>
                                </button>
                            </div>
                            <div class="w-25 mr-2">
                                <select name="lesson_id" class="w-100 h-100 border-1" x-model="lesson_id">
                                    <option value="">Select lessons...</option>
                                    @foreach($lessons as $lesson)
                                    <option value="{{$lesson->id}}">{{$lesson->short_name. ' - ' .$lesson->name}}
                                    </option>
                                    @endforeach
                                    {{-- <template x-for="(item, index) in attendances">
                                        <option :value="item.lesson_id"
                                            x-text="item.lessons.short_name + ' - ' + item.lessons.name"></option>
                                    </template> --}}
                                </select>
                            </div>
                            <div class="w-25">
                                <input type="date" class="w-100 h-100 border-1" x-model="log_date">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row border-bottom">
                    <div class="table">
                        <div class="table-wrapper">
                            <div class="table-header bg-black text-light">
                                <div class="row table-row-5">
                                    <span class="font-sm">{!! strtoupper('N') !!}</span>
                                </div>
                                <div class="row table-row-15">
                                    <span class="font-sm">{!! strtoupper('Log date') !!}</span>
                                </div>
                                <div class="row table-row-80">
                                    <span class="font-sm">{!! strtoupper('Lesson Name') !!}</span>
                                </div>
                                <div class="row table-row-15">
                                    <span class="font-sm">{!! strtoupper('Action') !!}</span>
                                </div>
                            </div>
                            <div class="table-body overflow-auto">
                                <template x-for="(item, index) in attendances">
                                    <template x-if="item.student_id.includes(student.id)">
                                        <div class="column">
                                            <div class="row table-row-5">
                                                <span x-text="index + 1"></span>
                                            </div>
                                            <div class="row table-row-15">
                                                <span x-text="item.log_date.slice(0, 10)"></span>
                                            </div>
                                            <div class="row table-row-65">
                                                <span
                                                    x-text="item.lessons.short_name + ' - ' + item.lessons.name"></span>
                                            </div>
                                            <div
                                                class="row table-row-15 h-100 d-flex justify-content-center align-items-center">
                                                <span class="font-sm h-50">
                                                    <button class="btn-create bg-danger h-100"
                                                        @click="onDeleteStudentAttendance(item.id, student.id)">
                                                        <span>{!!
                                                            strtoupper('Delete') !!}</span>
                                                    </button>
                                                </span>
                                            </div>
                                        </div>
                                    </template>
                                </template>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <h4 class="mb-0">Absent Attendance</h4>
                    <div class="table">
                        <div class="table-wrapper">
                            <div class="table-header bg-black text-light">
                                <div class="row table-row-5">
                                    <span class="font-sm">{!! strtoupper('N') !!}</span>
                                </div>
                                <div class="row table-row-15">
                                    <span class="font-sm">{!! strtoupper('Log date') !!}</span>
                                </div>
                                <div class="row table-row-80">
                                    <span class="font-sm">{!! strtoupper('Lesson Name') !!}</span>
                                </div>
                            </div>
                            <div class="table-body overflow-auto">
                                <template x-for="(item, index) in attendances">
                                    <template x-if="!item.student_id.includes(student.id)">
                                        <div class="column">
                                            <div class="row table-row-5">
                                                <span x-text="index + 1"></span>
                                            </div>
                                            <div class="row table-row-15">
                                                <span x-text="item.log_date.slice(0, 10)"></span>
                                            </div>
                                            <div class="row table-row-80">
                                                <span x-text="item.lessons.short_name + ' - ' + item.lessons.name">
                                                </span>
                                            </div>
                                        </div>
                                    </template>
                                </template>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</template>