<template x-if="structureProgram">
    <div class="classLogDialogLayout">
        <div class="classLogDialog p-4 overflow-auto" style="width: 90% !important">
            <div>
                <div class="d-flex justify-content-between mb-3">
                    <h2 class="m-0">
                        {!! strtoupper('Structure program detial') !!}
                    </h2>
                    <span @click="openStructureProgram()" class="cursor-pointer btn-close">
                    </span>
                </div>
                <div class="row">
                    <div class="row border-1-gray p-4 mb-3">
                        <div class="row">
                            <h3 class="mt-0">{{strtoupper('Structure Program')}}</h3>
                        </div>
                        <div class="row-3">
                            <div class="form-row">
                                <span>
                                    Structure Program Id
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                    {{$data->class_structure_program->structure_program->id ?? '--'}}
                                </span>
                            </div>
                            <div class="form-row">
                                <span>
                                    Occupation
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                    {{$data->class_structure_program->structure_program->class_occupation->name ??
                                    '--'}}
                                </span>
                            </div>
                            <div class="form-row">
                                <span>
                                    Lesson count
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                    {{count($lessons)}}
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="row border-1-gray p-4 mb-3">
                        <div class="row">
                            <h3 class="mt-0">{{strtoupper('Lesson Information')}}</h3>
                        </div>
                        <div class="row">
                            <div class="table">
                                <div class="table-wrapper p-0">
                                    <div class="table-header bg-black text-light">
                                        <div class="row table-row-10">
                                            <span class="font-sm">{!! strtoupper('N°') !!}</span>
                                        </div>
                                        <div class="row table-row-10">
                                            <span class="font-sm">{!! strtoupper('id') !!}</span>
                                        </div>
                                        <div class="row table-row-15">
                                            <span class="font-sm">{!! strtoupper('occupation') !!}</span>
                                        </div>
                                        <div class="row table-row-15">
                                            <span class="font-sm">{!! strtoupper('Short name') !!}</span>
                                        </div>
                                        <div class="row table-row-15">
                                            <span class="font-sm">{!! strtoupper('full Name') !!}</span>
                                        </div>
                                        <div class="row table-row-15">
                                            <span class="font-sm">{!! strtoupper('practice hour') !!}</span>
                                        </div>
                                        <div class="row table-row-15">
                                            <span class="font-sm">{!! strtoupper('theory hour') !!}</span>
                                        </div>
                                        <div class="row table-row-15">
                                            <span class="font-sm">{!! strtoupper('competency') !!}</span>
                                        </div>
                                    </div>
                                    <div class="table-body overflow-auto">
                                        @foreach($lessons as $index => $lesson)
                                        <div class="column">
                                            <div class="row table-row-10">
                                                <span class="font-sm">{!! $index + 1 !!}</span>
                                            </div>
                                            <div class="row table-row-10">
                                                <span class="font-sm">{!! $lesson->id ?? '--' !!}</span>
                                            </div>
                                            <div class="row table-row-15">
                                                <span class="font-sm">{!! $lesson->occupation-> name ?? '--' !!}</span>
                                            </div>
                                            <div class="row table-row-15">
                                                <span class="font-sm">{!! $lesson->short_name ?? '--' !!}</span>
                                            </div>
                                            <div class="row table-row-15">
                                                <span class="font-sm">{!! $lesson->name ?? '--' !!}</span>
                                            </div>
                                            <div class="row table-row-15">
                                                <span class="font-sm">{!! $lesson->practice_hour ?? '--' !!}</span>
                                            </div>
                                            <div class="row table-row-15">
                                                <span class="font-sm">{!! $lesson->theory_hour ?? '--' !!}</span>
                                            </div>
                                            <div class="row table-row-15">
                                                <span class="font-sm">{!! $lesson->competency_type ?? '--' !!}</span>
                                            </div>
                                        </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row border-1-gray p-4 mb-3">
                        <div class="row">
                            <h3 class="mt-0">{{strtoupper('class Information')}}</h3>
                        </div>
                        <div class="row-3">
                            <div class="form-row">
                                <span>
                                    Class ID
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                    {{$data->id ?? '--'}}
                                </span>
                            </div>
                            <div class="form-row">
                                <span>
                                    Class Code
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                    {{$data->class_code ?? '--'}}
                                </span>
                            </div>
                            <div class="form-row">
                                <span>
                                    Trainer
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                    {{$data->staff->full_name ?? '--'}}
                                </span>
                            </div>
                        </div>
                        <div class="row-3">
                            <div class="form-row">
                                <span>
                                    Class Status
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                    {{$data->class_status->name ?? '--'}}
                                </span>
                            </div>
                            <div class="form-row">
                                <span>
                                    Class Level
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                    {{$data->class_level->name ?? '--'}}
                                </span>
                            </div>
                            <div class="form-row">
                                <span>
                                    Class Type
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                    {{$data->class_level->name ?? '--'}}
                                </span>
                            </div>
                        </div>
                        <div class="row-3">
                            <div class="form-row">
                                <span>
                                    Class Shift
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                    {{$data->shift->name ?? '--'}}
                                </span>
                            </div>
                            <div class="form-row">
                                <span>
                                    Class Generation
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                    {{$data->generation ?? '--'}}
                                </span>
                            </div>
                            <div class="form-row">
                                <span>
                                    Class Group
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                    {{$data->group ?? '--'}}
                                </span>
                            </div>
                        </div>
                        <div class="row-3">
                            <div class="form-row">
                                <span>
                                    Class Start at
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                    {{$data->start_date}}
                                </span>
                            </div>
                            <div class="form-row">
                                <span>
                                    Class Finish at
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                    {{$data->end_date}}
                                </span>
                            </div>
                            <div class="form-row">
                                <span>
                                    Class Period
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                    {{$data->period_duration ?? '--'}}
                                </span>
                            </div>
                        </div>
                        <div class="row-3">
                            <div class="form-row">
                                <span>
                                    Google Sheet (View)
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                    <a href="{{$data->url_google_sheet_view ?? '#'}}" target="_blank">
                                        Visit
                                    </a>
                                </span>
                            </div>
                            <div class="form-row">
                                <span>
                                    Google Sheet (Edit)
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                    <a href="{{$data->url_google_sheet_edit ?? '#'}}" target="_blank">
                                        Visit
                                    </a>
                                </span>
                            </div>
                            <div class="form-row">
                                <span>
                                    Total Student
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                    {{count($data->students)}}
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="row border-1-gray p-4 mb-4">
                        <div class="row">
                            <h3 class="mt-0">
                                {{strtoupper('Student In Class')}}
                            </h3>
                        </div>
                        <div class="row">
                            <div class="table">
                                <div class="table-wrapper">
                                    <div class="table-header bg-black text-light">
                                        <div class="row table-row-10">
                                            <span class="font-sm">{!! strtoupper('STU. ID') !!}</span>
                                        </div>
                                        <div class="row table-row-20">
                                            <span class="font-sm">{!! strtoupper('Student name KH') !!}</span>
                                        </div>
                                        <div class="row table-row-20">
                                            <span class="font-sm">{!! strtoupper('student name') !!}</span>
                                        </div>
                                        <div class="row table-row-13">
                                            <span class="font-sm">{!! strtoupper('Tel.') !!}</span>
                                        </div>
                                        <div class="row table-row-10">
                                            <span class="font-sm">{!! strtoupper('Gender') !!}</span>
                                        </div>
                                        <div class="row table-row-12">
                                            <span class="font-sm">{!! strtoupper('Date of Birth') !!}</span>
                                        </div>
                                        <div class="row table-row-15">
                                            <span class="font-sm">{!! strtoupper('other') !!}</span>
                                        </div>
                                    </div>
                                    <div class="table-body overflow-auto">
                                        @foreach($data->students->sortBy('id') as $student)
                                        <div class="column">
                                            <div class="row table-row-10">
                                                <span class="font-sm">{!! $student->id ?? '--'!!}</span>
                                            </div>
                                            <div class="row table-row-20">
                                                <span class="font-sm">{!! $student->name_khmer ?? '--'!!}</span>
                                            </div>
                                            <div class="row table-row-20">
                                                <span class="font-sm">{!! $student->name_latin ?? '--'!!}</span>
                                            </div>
                                            <div class="row table-row-13">
                                                <span class="font-sm">{!! $student->phone ?? '--'!!}</span>
                                            </div>
                                            <div class="row table-row-10">
                                                <span class="font-sm">{!! $student->gender ?? '--'!!}</span>
                                            </div>
                                            <div class="row table-row-12">
                                                <span class="font-sm">{!! $student->dob ?? '--'!!}</span>
                                            </div>
                                            <div class="row table-row-15">
                                                <span class="font-sm">{!! $student->noted ?? '--'!!}</span>
                                            </div>
                                        </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</template>