<div id="overall" class="form-body p-3 mt-3">
    <h2>
        {!! strtoupper('Overall qualified status') !!}
    </h2>
    <div class="row">
        <div class="table">
            <div class="table-wrapper">
                <div class="table-header bg-black text-light">
                    <div class="row table-row-10">
                        <span class="font-sm">{!! strtoupper('student ID') !!}</span>
                    </div>
                    <div class="row table-row-10">
                        <span class="font-sm">{!! strtoupper('Fullname') !!}</span>
                    </div>
                    <div class="row table-row-20">
                        <span class="font-sm">{!! strtoupper('is attendance pass') !!}</span>
                    </div>
                    <div class="row table-row-20">
                        <span class="font-sm">{!! strtoupper('is exam pass') !!}</span>
                    </div>
                    <div class="row table-row-20">
                        <span class="font-sm">{!! strtoupper('is intern pass') !!}</span>
                    </div>
                    <div class="row table-row-20">
                        <span class="font-sm">{!! strtoupper('is overall pass') !!}</span>
                    </div>
                </div>
                @php
                $attendance = 0;
                $exam = 0;
                $intern = 0;
                @endphp
                <div class="table-body overflow-auto">
                    @foreach($student_in_class as $student)
                    <div class="column">
                        <div class="row table-row-10">
                            <span>{!! $student->id !!}</span>
                        </div>
                        <div class="row table-row-10">
                            <span>{!! $student->name_khmer !!}</span>
                        </div>
                        @if(count($student->attendance_statuses) > 0)
                        @foreach($student->attendance_statuses as $stu_status)
                        <div
                            class="row table-row-20 {{ $stu_status->attend_status == 1 ? 'text-success' : 'text-danger' }}">
                            <span>{{
                                $stu_status->attend_status == 1 ? "Passed" : "Failed"
                                }}</span>
                        </div>
                        @php
                        $attendance = $stu_status->attend_status
                        @endphp
                        @endforeach
                        @else
                        <div class="row table-row-20">
                            <span>{!! "--" !!}</span>
                        </div>
                        @endif

                        @if(count($student->student_score) > 0)
                        @foreach($student->student_score as $ss)
                        <div class="row table-row-20 {!! $ss->pass_status == 1 ? " text-success" : "text-danger" !!}">
                            <span>{!! $ss->pass_status == 1 ? "Passed" : "Failed" !!}</span>
                        </div>
                        @php
                        $exam = $ss->pass_status
                        @endphp
                        @endforeach
                        @else
                        <div class="row table-row-20">
                            <span>{!! "--" !!}</span>
                        </div>
                        @endif

                        @if(count($student->student_intern_places))
                        @foreach($student->student_intern_places as $stu_intern)
                        <div
                            class="row table-row-20 {{$stu_intern->is_intern_pass == 1 ? 'text-success' : 'text-danger'}}">
                            <span>{{$stu_intern->is_intern_pass == 1 ? "Passed" : "Failed"}}</span>
                        </div>
                        @php
                        $intern = $stu_intern->is_intern_pass
                        @endphp
                        @endforeach
                        @else
                        <div class="row table-row-20">
                            <span>{!! "--" !!}</span>
                        </div>
                        @endif

                        @if($attendance == 1 && $exam == 1 && $intern == 1)
                        <div class="row table-row-20 text-success">
                            <span>Passed</span>
                        </div>
                        @else
                        <div class="row table-row-20 text-danger">
                            <span>Failed</span>
                        </div>
                        @endif
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>