<div id="student-list" class="form-body p-3 mt-3">
    <h2>
        {!! strtoupper('Student list') !!}
    </h2>
    <form action="{{route('admin-printing-student', ['about'=> true, 'id'=>request('id')])}}" method="GET">
        <div class="row">
            @can('student-print')
            <div class="form-row flex-row">
                <div class="btn-create bg-primary mr-2 cursor-pointer d-flex justify-content-center align-items-center p-3"
                    style="border-radius: 5px" @click="toggleAllCheckboxes()">
                    <span class="text-light">{!! strtoupper('Checked all') !!}</span>
                </div>
                <button class="btn-create bg-primary mr-2" type="submit">
                    <i data-feather="printer"></i>
                    <span>{!! strtoupper('print') !!}</span>
                </button>
                <div class="checkItem mr-2 d-flex justify-content-center align-items-center">
                    <label for="image">Show Image</label>
                    <input type="checkbox" name="show_image" value="true" id="image" checked />
                </div>
            </div>
            @endcan
        </div>
        <div class="row">
            <div class="table">
                <div class="table-wrapper">
                    <div class="table-header bg-black text-light">
                        <div class="row table-row-7">
                            <span class="font-sm">{!! strtoupper('select') !!}</span>
                        </div>
                        <div class="row table-row-6">
                            <span class="font-sm">{!! strtoupper('STU. ID') !!}</span>
                        </div>
                        <div class="row table-row-15">
                            <span class="font-sm">{!! strtoupper('Student name KH') !!}</span>
                        </div>
                        <div class="row table-row-15">
                            <span class="font-sm">{!! strtoupper('student name') !!}</span>
                        </div>
                        <div class="row table-row-10">
                            <span class="font-sm">{!! strtoupper('Tel.') !!}</span>
                        </div>
                        <div class="row table-row-10">
                            <span class="font-sm">{!! strtoupper('Gender') !!}</span>
                        </div>
                        <div class="row table-row-10">
                            <span class="font-sm">{!! strtoupper('Date of Birth') !!}</span>
                        </div>
                        <div class="row table-row-12">
                            <span class="font-sm">{!! strtoupper('other') !!}</span>
                        </div>
                        <div class="row table-row-10">
                            <span class="font-sm">{!! strtoupper('joined on') !!}</span>
                        </div>
                        <div class="row table-row-5">
                            <span class="font-sm">{!! strtoupper('action') !!}</span>
                        </div>
                    </div>
                    <div class="table-body overflow-visible">
                        @foreach($data->students->sortBy('id') as $student)
                        <div class="column">
                            <div class="row table-row-7">
                                <span>
                                    <input class="item-select-input" type="checkbox" name="student_id[]"
                                        value="{!! $student->id !!}" x-model="selectStudents" />
                                </span>
                            </div>
                            <div class=" row table-row-6">
                                <span>
                                    {!! $student->id ?? '--' !!}
                                </span>
                            </div>
                            <div class="row table-row-15">
                                <span>
                                    {!! $student->name_khmer ?? '--' !!}
                                </span>
                            </div>
                            <div class="row table-row-15">
                                <span>
                                    {!! $student->name_latin ?? '--' !!}
                                </span>
                            </div>
                            <div class="row table-row-10">
                                <span>
                                    {!! $student->phone ?? '--' !!}
                                </span>
                            </div>
                            <div class="row table-row-10">
                                <span>
                                    {!! $student->gender ?? '--' !!}
                                </span>
                            </div>
                            <div class="row table-row-10">
                                <span>
                                    {!! $student->dob ?? '--' !!}
                                </span>
                            </div>
                            <div class="row table-row-12">
                                <span>
                                    {!! $student->note ?? '--' !!}
                                </span>
                            </div>
                            <div class="row table-row-10">
                                <span>
                                    {!! $student->pivot->created_at ?? '--' !!}
                                </span>
                            </div>
                            <div class="row table-row-5">
                                @canany(['student-view-info', 'class-remove-student'])
                                <div class="dropdown">
                                    <i data-feather="more-vertical" class="action-btn" id="dropdownMenuButton"
                                        data-mdb-toggle="dropdown" aria-expanded="false">
                                    </i>
                                    <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                        @can('student-view-info')
                                        <li>
                                            <a class="dropdown-item"
                                                s-click-link=" {!! route('admin-student-view', $student->id) !!}">
                                                <i data-feather="monitor"></i>
                                                <span>View Info</span>
                                            </a>
                                        </li>
                                        @endcan
                                        @can('class-remove-student')
                                        <li>
                                            <a class="dropdown-item disable-btn" onclick="$onConfirmMessage(
                                                    '{!! route('admin-class-remove-student', ['student_id' => $student->id, 'class_id' => request('id')]) !!}',
                                                    'Are you sure to remove {{$student->name_khmer}} from class {{request('id')}}',
                                                    {
                                                        confirm: '@lang('dialog.button.ok')',
                                                        cancel: '@lang('dialog.button.cancel')'
                                                    }
                                                );">
                                                <i data-feather="x-circle"></i>
                                                <span>Remove Student</span>
                                            </a>
                                        </li>
                                        @endcan
                                    </ul>
                                </div>
                                @endcan
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>