<div id="student-score" class="form-body p-3 mt-3">
    <h2>
        {!! strtoupper('Student score record') !!}
    </h2>
    <div class="row">
        <div class="form-row flex-row">
            @canany(['student-score-print', 'student-score-create'])
            {{-- @can('student-score-create')
            <button class="btn-create bg-primary mr-2">
                <i data-feather="monitor"></i>
                <span class="text-light"
                    s-click-link="{{route('admin-exam-control-enter-student-score', ['class_id' => $data->id])}}"
                    target="_blank">{!! strtoupper('view
                    entry page') !!}</span>
            </button>
            @endcan --}}
            @can('student-score-print')
            <button class="btn-create bg-primary mr-2"
                s-click-link="{{route('admin-printing-student-score', request('id'))}}">
                <i data-feather="printer"></i>
                <span>{!! strtoupper('print score table') !!}</span>
            </button>
            @endcan
            @endcan
        </div>
    </div>
    <div class="row">
        <div class="table">
            <div class="table-wrapper">
                <div class="table-header bg-black text-light w-100">
                    <div class="row table-row-10">
                        <span class="font-sm">អត្តលេខ</span>
                    </div>
                    <div class="row table-row-13">
                        <span class="font-sm">ឈ្មោះ(ខ្មែរ)</span>
                    </div>
                    @foreach($limit_3_lessons as $lesson)
                    <div class="row table-row-14">
                        <span class="font-sm">{!! $lesson->id.'|'.$lesson->short_name !!}</span>
                    </div>
                    @endforeach
                    <div class="row table-row-10">
                        <span class="font-sm">{!! strtoupper('total score') !!}</span>
                    </div>
                    <div class="row table-row-10">
                        <span class="font-sm">{!! strtoupper('ranking') !!}</span>
                    </div>
                    <div class="row table-row-10">
                        <span class="font-sm">{!! strtoupper('pass status') !!}</span>
                    </div>
                    <div class="row table-row-5">
                    </div>
                </div>
                <div class="table-body overflow-auto">
                    @foreach($student_in_class as $student)
                    <div class="column w-100">
                        <div class="row table-row-10">
                            <span>
                                {!! $student->sid ?? '--' !!}
                            </span>
                        </div>
                        <div class="row table-row-13">
                            <span>
                                {!! $student->name_khmer !!}
                            </span>
                        </div>
                        @foreach($limit_3_lessons as $lesson)
                        <div class="row table-row-14">
                            @if(count($student->exam_score))
                            @foreach($student->exam_score as $es)
                            @if($es->lesson_id == $lesson->id)
                            <span>{{$es->score}}</span>
                            @endif
                            @endforeach
                            @else
                            <span>--</span>
                            @endif
                        </div>
                        @endforeach
                        @if(count($student->student_score))
                        @foreach($student->student_score as $ss)
                        <div class="row table-row-10">
                            <span>{{$ss->total_score ?? '--'}} pts</span>
                        </div>
                        <div class="row table-row-10">
                            <span>{{$ss->ranking ?? '--'}}</span>
                        </div>
                        <div class="row table-row-10">
                            <span
                                class="{{$ss->pass_status ? $ss->pass_status == 1 ? 'text-success' : 'text-danger' : 'text-danger'}}">{{$ss->pass_status
                                ? $ss->pass_status == 1 ? 'PASSED' : 'FAILED' : 'FAILED'}}</span>
                        </div>
                        @endforeach
                        @else
                        <div class="row table-row-10">
                            <span>--</span>
                        </div>
                        <div class="row table-row-10">
                            <span>--</span>
                        </div>
                        <div class="row table-row-10">
                            <span>--</span>
                        </div>
                        @endif
                        <div class="row table-row-5">
                            @canany(['student-score-create'])
                            <div class="dropdown">
                                <i data-feather="more-vertical" class="action-btn" id="dropdownMenuButton"
                                    data-mdb-toggle="dropdown" aria-expanded="false">
                                </i>
                                <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                    @can('student-score-create')
                                    <li @click="studentScore({{$student}})">
                                        <a class="dropdown-item"></i>
                                            <i data-feather="file-plus"></i>
                                            <span>Enter/Update Student Score</span>
                                        </a>
                                    </li>
                                    @endcan
                                </ul>
                            </div>
                            @endcan
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
    @include('admin::pages.class.view-info.modal.student-score')
</div>