@extends('admin::shared.layout')
@section('layout')
<div class="form-admin">
    <div class="form-bg"></div>
    <form id="form" class="form-wrapper" action="{!! route('admin-contact-save')!!}" method="POST"
        enctype="multipart/form-data">
        <div class="form-header">
            <h3>
                Contact
            </h3>
        </div>
        {{ csrf_field() }}
        <div class="form-body">
            <div class="row-2">
                <div class="form-row">
                    <label>Name<span>*</span></label>
                    <input type="text" name="name" placeholder="Customer Service"
                        value="{!! $data ? $data->name : old('name') !!}">
                    @error('name')
                    <label class="error">{{ $message }}</label>
                    @enderror
                </div>
                <div class="form-row">
                    <label for="">Phone<span>*</span></label>
                    <input type="text" name="phone" placeholder="(+855) 00 00 00 00"
                        value="{!! $data ? $data->phone : old('phone') !!}">
                    @error('phone')
                    <label class="error">{{ $message }}</label>
                    @enderror
                </div>
            </div>
            <div class="row-2">
                <div class="form-row">
                    <label>Email<span>*</span></label>
                    <input type="text" name="email" placeholder="" value="{!! $data ? $data->email : old('email') !!}">
                    @error('email')
                    <label class="error">{{ $message }}</label>
                    @enderror
                </div>
            </div>
            <div class="row-2">
                <div class="form-row">
                    <label>Address<span>*</span></label>
                    <textarea style="min-height: 125px;"
                        name="address">{!! $data ? $data->address : old('address') !!}</textarea>
                    @error('address')
                    <label class="error">{{ $message }}</label>
                    @enderror
                </div>
                <div class="form-row">
                    <label>Google Map URL Embed</label>
                    <textarea style="min-height: 125px;"
                        name="google_map">{!! $data ? $data->google_map : old('google_map') !!}</textarea>
                    @error('google_map')
                    <label class="error">{{ $message }}</label>
                    @enderror
                </div>
            </div>
            <div class="row-2">
                <div class="form-row">
                    <label>Facebook</label>
                    <textarea style="min-height: 125px;"
                        name="facebook">{!! $data ? $data->facebook : old('facebook') !!}</textarea>
                    @error('facebook')
                    <label class="error">{{ $message }}</label>
                    @enderror
                </div>
                <div class="form-row">
                    <label>Instagram</label>
                    <textarea style="min-height: 125px;"
                        name="instagram">{!! $data ? $data->instagram : old('instagram') !!}</textarea>
                    @error('instagram')
                    <label class="error">{{ $message }}</label>
                    @enderror
                </div>
            </div>
            <div class="row-2">
                <div class="form-row">
                    <label>Youtube</label>
                    <textarea style="min-height: 125px;"
                        name="youtube">{!! $data ? $data->youtube : old('youtube') !!}</textarea>
                    @error('youtube')
                    <label class="error">{{ $message }}</label>
                    @enderror
                </div>
                <div class="form-row">
                    <label>Telegram</label>
                    <textarea style="min-height: 125px;"
                        name="telegram">{!! $data ? $data->telegram : old('telegram') !!}</textarea>
                    @error('telegram')
                    <label class="error">{{ $message }}</label>
                    @enderror
                </div>
            </div>
            <div class="form-button">
                <button type="submit" color="primary">
                    <i data-feather="save"></i>
                    <span>Submit</span>
                </button>
            </div>
        </div>
        <div class="form-footer"></div>
    </form>
</div>
@stop
@section('script')
<script>
    $(document).ready(function() {
        $validator("#form", {
            name: {
                required: true,
            },
            email: {
                required: true,
            },
            phone: {
                required: true,
            },
            address: {
                required: true,
            },
        });
    });
</script>
@stop