@extends('admin::shared.layout')
@section('layout')
<div class="form-admin">
    <div class="form-bg"></div>
    <form id="form" class="form-wrapper" action="{!! route('admin-course-save', request('id'))!!}" method="POST"
        enctype="multipart/form-data">
        <div class="form-header">
            <h3>
                Course
            </h3>
        </div>
        {{ csrf_field() }}
        <div class="form-body">
            <div class="row-2">
                <div class="form-row">
                    <label>Title<span>*</span></label>
                    <input type="text" name="name" placeholder=""
                        value="{!! request('id') ? $data->name : old('name') !!}">
                    @error('name')
                    <label class="error">{{ $message }}</label>
                    @enderror
                </div>
                <div class="form-row">
                    <label>Status<span>*</span></label>
                    <select name="status" id="">
                        <option value="1" {{request('id') && $data->status == 1 ? 'selected' : old('status')}}>Active
                        </option>
                        <option value="1" {{request('id') && $data->status == 2 ? 'selected' : old('status')}}>Disable
                        </option>
                    </select>
                    @error('title')
                    <label class="error">{{ $message }}</label>
                    @enderror
                </div>
            </div>
            <div class="row-2">
                <div class="form-row">
                    <label>Date<span>*</span></label>
                    <input type="datetime-local" name="date" value="{!! request('id') ? $data->date : old('date') !!}">
                    @error('date')
                    <label class="error">{{ $message }}</label>
                    @enderror
                </div>
                <div class="form-row">
                    <label>Duration<span>*</span></label>
                    <input type="text" name="duration" placeholder="4 hs"
                        value="{!! request('id') ? $data->duration : old('duration') !!}">
                    @error('duration')
                    <label class="error">{{ $message }}</label>
                    @enderror
                </div>
            </div>
            <div class="row-2">
                <div class="form-row">
                    <label>Fee</label>
                    <input type="text" name="fee" placeholder="Free/10$" autocomplete
                        value="{!! request('id') ? $data->fee : old('fee') !!}">
                    @error('fee')
                    <label class="error">{{ $message }}</label>
                    @enderror
                </div>
                <div class="form-row">
                    <label>Trainer</label>
                    <select name="trainer_id" id="">
                        <option value="">Select Trainer</option>
                        @foreach($trainers as $trainer)
                        <option value="{{$trainer->id}}" {{ request('id') ? $trainer->id == $data->trainer_id ? 'selected' :
                            '' : old('trainer_id')}}>
                            {{$trainer->position ?? ''}} - {{$trainer->name ?? ''}}
                        </option>
                        @endforeach
                    </select>
                    @error('trainer')
                    <label class="error">{{ $message }}</label>
                    @enderror
                </div>
            </div>
            <div class="row-2">
                <div class="form-row">
                    <label>Contact Number</label>
                    <input type="text" name="contact_number" placeholder="(+855) 00 00 00 00" autocomplete
                        value="{!! request('id') ? $data->contact_number : old('contact_number') !!}">
                    @error('contact_number')
                    <label class="error">{{ $message }}</label>
                    @enderror
                </div>
            </div>
            <div class="row-2">
                <div class="form-row flex-row">
                    <label class="cursor-pointer" for="popular">Popular</label>
                    <input class="cursor-pointer" style="height: 20px; width: auto" type="checkbox" name="popular" id="popular" value="1"
                        {{request('id') && $data->popular == 1 ? 'checked' : ''}}>
                </div>
            </div>
            <div class="row-2">
                <div class="form-row">
                    <label>Description</label>
                    <textarea style="min-height: 300px;"
                        name="description">{!! request('id') ? $data->description : old('description') !!}</textarea>
                    @error('description')
                    <label class="error">{{ $message }}</label>
                    @enderror
                </div>
                <div class="form-row">
                    <label>Image</label>
                    <div class="form-select-photo image">
                        <div
                            class="select-photo {!! request('id') && isset($data) && $data->image != null ? 'active' : '' !!}">
                            <div class="icon">
                                <i data-feather="image"></i>
                            </div>
                            <div class="title">
                                <span>@lang('user.form.profile.placeholder')</span>
                            </div>
                        </div>
                        <div
                            class="image-view {!! request('id') && isset($data) && $data->image != null ? 'active' : '' !!}">
                            <img src="{!! request('id') && isset($data) && $data->image != null ? asset('file_manager' . $data->image) : null !!}"
                                onerror="(this).src='{{ asset('images/logo/default.png') }}'" alt="">
                        </div>
                        <input type="text" name="image" s-click-fn="selectImage(event)" autocomplete="off"
                            role="presentation">
                        <input type="hidden" name="tmp_file"
                            value="{!! request('id') && isset($data) && $data->image != null ? $data->image : '' !!}">
                    </div>
                </div>
            </div>
            <div class="form-button">
                <button type="submit" color="primary">
                    <i data-feather="save"></i>
                    <span>Submit</span>
                </button>
                <button color="danger" type="button" s-click-link="{!! route('admin-course-list', 1) !!}">
                    <i data-feather="x"></i>
                    <span>Cancel</span>
                </button>
            </div>
        </div>
        <div class="form-footer"></div>
    </form>
</div>
@include('admin::file-manager.popup')
@stop
@section('script')
<script>
    $(document).ready(function() {
        $validator("#form", {
            name: {
                required: true,
            },
            date: {
                required: true,
            },
            duration: {
                required: true,
            },
        });
    });
    function selectImage(e) {
            fileManager({
                multiple: false,
                afterClose: (data, basePath) => {
                    if (data?.length > 0) {
                        const parent = e.target.closest('.form-select-photo');
                        e.target.value = data[0].path;
                        parent
                            .querySelector('.select-photo')
                            .classList.add('active');
                        parent
                            .querySelector('.image-view')
                            .classList
                            .add('active');
                        parent
                            .querySelector('.image-view')
                            .childNodes[0]
                            .nextElementSibling
                            .setAttribute('src', basePath + data[0].path);
                    }
                }
            })
        }
</script>
@stop