<template x-if="dialogOpen">
    <div>
        <template x-if="status == 2">
            <div class="classLogDialogLayout">
                <div class="classLogDialog p-3 h-auto">
                    <div class="form-admin p-3">
                        <div id="form" class="form-wrapper p-0">
                            <div class="form-body p-0" style="box-shadow: none">
                                <div class="row">
                                    <h2 class="mt-0">
                                        {{strtoupper('add new exam info')}}
                                    </h2>
                                </div>
                                {{-- {{ csrf_field() }} --}}
                                <div class="row-2">
                                    <div class="form-row">
                                        <label>{{strtoupper('class id')}} <span>*</span></label>
                                        <div class="w-100 h-100 d-flex align-items-center"
                                            style="border: 1px solid #d8dce5; border-radius: 4px;color: #5a5e66;padding: 0 15px; font-size:14px;">
                                            {{request('class_id')}}</div>
                                    </div>
                                    <div class="form-row">
                                        <label>{{strtoupper('Exam type')}} <span>*</span></label>
                                        <select name="exam_type_id" id="" x-model="exam_type_id">
                                            <option value="">Please select</option>
                                            @foreach($exam_types as $exam_type)
                                            <template x-if="exam_control.exam_type_id == {{$exam_type->id}}">
                                                <option :value="exam_type_id={{$exam_type->id}}" selected>
                                                    {{$exam_type->name}}
                                                </option>
                                            </template>
                                            <template x-if="exam_control.exam_type_id != {{$exam_type->id}}">
                                                <option value="{{$exam_type->id}}">{{$exam_type->name}}
                                                </option>
                                            </template>
                                            {{-- <option value="{{$exam_type->id}}">{{$exam_type->name}}</option> --}}
                                            @endforeach
                                        </select>
                                        @error('exam_type_id')
                                        <span class="error">{{$message}}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="row-2">
                                    <div class="form-row">
                                        <label>{{strtoupper('exam date')}} <span>*</span></label>
                                        <input type="date" name="exam_date" x-model="exam_date"
                                            :value="exam_date=exam_control.exam_date_only">
                                        @error('exam_date')
                                        <span class="error">{{$message}}</span>
                                        @enderror
                                    </div>
                                    <div class="form-row">
                                        <label>{{strtoupper('exam duration (days)')}} <span>*</span></label>
                                        <input type="number" name="exam_duration" x-model="exam_duration"
                                            placeholder="Please enter exam duration"
                                            :value="exam_duration=exam_control.duration">
                                        @error('exam_duration')
                                        <span class="error">{{$message}}</span>
                                        @enderror
                                    </div>

                                </div>
                                <div class="row">
                                    <div class="form-row">
                                        <label>{{strtoupper('exam note')}}</label>
                                        <textarea name="exam_noted" x-model="exam_noted"
                                            :value="exam_noted=exam_control.noted"
                                            placeholder="Please note something"></textarea>
                                        @error('exam_noted')
                                        <span class="error">{{$message}}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="form-button">
                                    <button type="submit" color="primary"
                                        @click="createExamControl({{request('class_id')}}, exam_id)">
                                        <i data-feather="save"></i>
                                        <span>Submit</span>
                                    </button>
                                    <button color="danger" type="button" @click="dialogOpenUpdate()">
                                        <i data-feather="x"></i>
                                        <span>Cancel</span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </template>
        <template x-if="status == 1">
            <div class="classLogDialogLayout">
                <div class="classLogDialog p-3 h-auto">
                    <div class="form-admin p-3">
                        <div id="form" class="form-wrapper p-0">
                            <div class="form-body p-0" style="box-shadow: none">
                                <div class="row">
                                    <h2 class="mt-0">
                                        {{strtoupper('add new exam info')}}
                                    </h2>
                                </div>
                                {{-- {{ csrf_field() }} --}}
                                <div class="row-2">
                                    <div class="form-row">
                                        <label>{{strtoupper('class id')}} <span>*</span></label>
                                        <div class="w-100 h-100 d-flex align-items-center"
                                            style="border: 1px solid #d8dce5; border-radius: 4px;color: #5a5e66;padding: 0 15px; font-size:14px;">
                                            {{request('class_id')}}</div>
                                    </div>
                                    <div class="form-row">
                                        <label>{{strtoupper('Exam type')}} <span>*</span></label>
                                        <select name="exam_type_id" id="" x-model="exam_type_id">
                                            <option value="">Please select</option>
                                            @foreach($exam_types as $exam_type)
                                            <option value="{{$exam_type->id}}">{{$exam_type->name}}</option>
                                            @endforeach
                                        </select>
                                        @error('exam_type_id')
                                        <span class="error">{{$message}}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="row-2">
                                    <div class="form-row">
                                        <label>{{strtoupper('exam date')}} <span>*</span></label>
                                        <input type="date" name="exam_date" x-model="exam_date">
                                        @error('exam_date')
                                        <span class="error">{{$message}}</span>
                                        @enderror
                                    </div>
                                    <div class="form-row">
                                        <label>{{strtoupper('exam duration (days)')}} <span>*</span></label>
                                        <input type="number" name="exam_duration" x-model="exam_duration"
                                            placeholder="Please enter exam duration">
                                        @error('exam_duration')
                                        <span class="error">{{$message}}</span>
                                        @enderror
                                    </div>

                                </div>
                                <div class="row">
                                    <div class="form-row">
                                        <label>{{strtoupper('exam note')}}</label>
                                        <textarea name="exam_noted" x-model="exam_noted"
                                            placeholder="Please note something"></textarea>
                                        @error('exam_noted')
                                        <span class="error">{{$message}}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="form-button">
                                    <button type="submit" color="primary"
                                        @click="createExamControl({{request('class_id')}}, exam_id)">
                                        <i data-feather="save"></i>
                                        <span>Submit</span>
                                    </button>
                                    <button color="danger" type="button" @click="dialogOpenCreate()">
                                        <i data-feather="x"></i>
                                        <span>Cancel</span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </template>
    </div>

</template>