@extends('admin::pages.printing.header')

@section('print-body')
@can('attendance-print')
<div class="body-content">
    <div class="section-1">
        <div class="title d-flex justify-content-center align-items-center">
            <template x-if="title == null">
                <span id="title" class="input whitespace-break span1"
                    style="font-family: 'Moul', cursive !important;">តារាងស្ថានភាពវត្តមានរបស់សិស្ស</span>
            </template>
            <template x-if="title != null">
                <span id="title" class="input whitespace-break span1" style="font-family: 'Moul', cursive !important;"
                    x-text="title"></span>
            </template>
        </div>
    </div>
    <div class="section-2 border-c p-3 mb-3 border-radius-5">
        <h3 class="m-0" style="font-weight: 600">ពត៏មានថ្នាក់</h3>
        <div class="d-flex justify-content-between font-md">
            <div class="part-1">
                <p>លេខកូដថ្នាក់: <span class="text-danger">{{$data->id ?? '--'}}</span></p>
                <p>គ្រូបន្ទុកថ្នាក់: <span class="text-danger">{{$data->staff->full_name ?? '--'}}</span></p>
            </div>
            <div class="part-1">
                <p>សិស្សសរុប: <span class="text-danger">{{$count}} នាក់ ( ស្រី {{$count_F}} នាក់)</span></p>
                <p>វេនសិក្សា: <span class="text-danger">{{$data->shift->name}}</span></p>
            </div>
            <div class="part-1">
                <p>ជំនាន់ទី: <span class="text-danger">{{$data->generation}}</span></p>
                <p>ក្រុមទី: <span class="text-danger">{{$data->group}}</span></p>
            </div>
            <div class="part-1">
                <p>ជំនាញនៃកម្មវិធី:
                    <span
                        class="text-danger">{{$data->class_structure_program->structure_program->class_occupation->name}}</span>
                </p>
                <p>ស្ថានភាពថ្នាក់: <span class="text-danger">{{$data->class_status->name}}</span></p>
            </div>
        </div>
    </div>
    <div>
        <div class="font-md">
            {{strtoupper('attendance info on: ')}}
            <span class="font-weight-bolder">
                {{request('date')}}
            </span>
        </div>
    </div>
    @if(count($attendance) > 0)
    <div class="mb-3 font-md">
        {{strtoupper('total student(s): ')}}
        @php
        $count_student = 0;
        foreach($attendance as $item){
        $cs = count($item->student_id);
        if($cs > $count_student){
        $count_student = $cs;
        }
        }
        @endphp
        <span class="font-weight-bolder">
            {{$count_student}}
        </span>
    </div>
    <div class="section-3">
        <table class="w-100 font-md">
            <tr>
                <th class="p-2" style="text-align: center">#</th>
                <th class="p-2" style="text-align: center">STUDENT ID</th>
                <th class="p-2" style="text-align: center">STUDENT NAME</th>
                <th class="p-2" style="text-align: center">LOG INFOS</th>
            </tr>
            @foreach($attendance as $index => $item)
            @foreacH($data->students as $student)
            @if(in_array($student->id, $item->student_id))
            <tr>
                <td class="p-2" style="text-align: center">{{$index+=1}}</td>
                <td class="p-2" style="text-align: center">{{$student->id ?? ''}}</td>
                <td class="p-2" style="text-align: center">{{$student->name_khmer ?? ''}}</td>
                <td class="p-2" style="text-align: center">
                    {{$item->lessons
                    ? "[".$item->lessons->short_name." - ".
                    $item->lessons->name."]
                    [".date_format(date_create($item->log_date), "H:i").
                    ']'
                    : '--'}}
                </td>
            </tr>
            @endif
            @endforeach
            @endforeach
        </table>
    </div>
    <br />
    <br />
    <div class="section-4">
        <div class="title d-flex">
            <template x-if="sign_date == null">
                <span class="input Battambang whitespace-break span2" id="sign_date"
                    x-text="'រាជធានីភ្នំពេញ ថ្ងៃទី ២៥ ខែ មីនា ឆ្នាំ​​ ២០២៣'"></span>
            </template>
            <template x-if="sign_date != null">
                <span class="input Battambang whitespace-break span2" id="sign_date" x-text="sign_date">
                </span>
            </template>
        </div>
        <div class="title d-flex">
            <template x-if="position == null">
                <span class="input Battambang whitespace-break span3" id="position">នាយកសាលា</span>
            </template>
            <template x-if="position != null">
                <span class="input Battambang whitespace-break span3" id="position" x-text="position"></span>
            </template>
        </div>
        <br />
        <br />
        <br />
        <br />
        <br />
        <div class="title d-flex">
            <template x-if="name == null">
                <span class="input Battambang whitespace-break span4" id="name">ឡា វិបុល</span>
            </template>
            <template x-if="name != null">
                <span class="input Battambang whitespace-break span4" id="name" x-text="name"></span>
            </template>
        </div>
    </div>
    @else
    <div class="text-danger font-weight-bolder">No Data!</div>
    @endif
</div>
@include('admin::pages.printing.setting')
@endcan
@stop