@extends('admin::pages.printing.header')

@section('print-body')
@can('student-print')
<div class="body-content">
    <div class="section-1">
        <div class="title d-flex justify-content-center align-items-center">
            <template x-if="title == null">
                <span id="title" class="input whitespace-break span1"
                    style="font-family: 'Moul', cursive !important;">បញ្ជីក្រុមសិស្ស</span>
            </template>
            <template x-if="title != null">
                <span id="title" class="input whitespace-break span1" style="font-family: 'Moul', cursive !important;"
                    x-text="title"></span>
            </template>
        </div>
        <div class="title d-flex justify-content-center align-items-center" style="display: none !important;">
            <template x-if="about == null">
                <span id="about" class="input whitespace-break span5"
                    style="font-family: 'Moul', cursive !important;">អំពី</span>
            </template>
            <template x-if="about != null">
                <span id="about" class="input whitespace-break span5" style="font-family: 'Moul', cursive !important;"
                    x-text="about"></span>
            </template>
        </div>
    </div>
    <div class="section-2 border-c p-3 mb-3 border-radius-5">
        <h3 class="m-0" style="font-weight: 600">ពត៏មានថ្នាក់</h3>
        <div class="d-flex justify-content-between font-md">
            <div class="part-1">
                <p>លេខកូដថ្នាក់: <span class="text-danger">{{$class->id ?? '--'}}</span></p>
                <p>គ្រូបន្ទុកថ្នាក់: <span class="text-danger">{{$class->staff->full_name ?? '--'}}</span></p>
            </div>
            <div class="part-1">
                <p>សិស្សសរុប: <span class="text-danger">{{$count}} នាក់ ( ស្រី {{$count_F}} នាក់)</span></p>
                <p>វេនសិក្សា: <span class="text-danger">{{$class->shift->name}}</span></p>
            </div>
            <div class="part-1">
                <p>ជំនាន់ទី: <span class="text-danger">{{$class->generation}}</span></p>
                <p>ក្រុមទី: <span class="text-danger">{{$class->group}}</span></p>
            </div>
            <div class="part-1">
                <p>ជំនាញនៃកម្មវិធី:
                    <span
                        class="text-danger">{{$class->class_structure_program->structure_program->class_occupation->name}}</span>
                </p>
                <p>ស្ថានភាពថ្នាក់: <span class="text-danger">{{$class->class_status->name}}</span></p>
            </div>
        </div>
    </div>
    <div class="section-3">
        <table class="w-100 font-md">
            <tr>
                <th class="p-2" style="text-align: center">លេខកូដ ក្រុម</th>
                <th class="p-2" style="text-align: center">ឈ្មោះក្រុម</th>
                <th class="p-2" style="text-align: center">ឈ្មោះសិស្ស</th>
                <th class="p-2" style="text-align: center">រូបថត</th>
            </tr>
            @foreach($data as $item)
            <tr>
                <td class="p-2" style="text-align: center">{{$item->id}}</td>
                <td class="p-2" style="text-align: center">{{$item->name}}</td>
                <td style="height: 100px">
                    <table style="border: none; height: 100%;">
                        @foreach($item->students as $student)
                        <tr style="border: none;" class="c-border">
                            <td style="border: none; text-align: center;">{{$student->name_khmer}}</td>
                        </tr>
                        @endforeach
                    </table>
                </td>
                <td style="width: 3.25cm; height: 100px">
                    <table style="border: none" class="font-md">
                        @foreach($item->students as $student)
                        <tr style="border: none;" class="c-border">
                            <td style="border: none;" class="p-2">
                                <div class="thumbnail photo h-100 w-100" data-fancybox
                                    data-src="{{ asset('file_manager' . $student->profile)  }}">
                                    <img class="w-100 h-100"
                                        src="{!! $student->profile != null ? asset('file_manager' . $student->profile) : asset('images/logo/default.png') !!}"
                                        onerror="(this).src='{{ asset('images/logo/default.png') }}'" alt="">
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </table>
                </td>
            </tr>
            @endforeach
        </table>
    </div>
    <br />
    <br />
    <div class="section-4">
        <div class="title d-flex">
            <template x-if="sign_date == null">
                <span class="input Battambang whitespace-break span2" id="sign_date"
                    x-text="'រាជធានីភ្នំពេញ ថ្ងៃទី ២៥ ខែ មីនា ឆ្នាំ​​ ២០២៣'"></span>
            </template>
            <template x-if="sign_date != null">
                <span class="input Battambang whitespace-break span2" id="sign_date" x-text="sign_date">
                </span>
            </template>
        </div>
        <div class="title d-flex">
            <template x-if="position == null">
                <span class="input Battambang whitespace-break span3" id="position">នាយកសាលា</span>
            </template>
            <template x-if="position != null">
                <span class="input Battambang whitespace-break span3" id="position" x-text="position"></span>
            </template>
        </div>
        <br />
        <br />
        <br />
        <br />
        <br />
        <div class="title d-flex">
            <template x-if="name == null">
                <span class="input Battambang whitespace-break span4" id="name">ឡា វិបុល</span>
            </template>
            <template x-if="name != null">
                <span class="input Battambang whitespace-break span4" id="name" x-text="name"></span>
            </template>
        </div>
    </div>
    @include('admin::pages.printing.setting')
    @stop
</div>
@endcan