@component('admin::components.dialog', ['dialog' => 'studyBackgroundDialog'])
    <div x-data="studyBackgroundDialog" class="form-admin overflow-hidden" style="width: 1000px">
        <form class="form-wrapper p-0">
            <div class="form-header d-flex justify-content-between align-items-center">
                <h3 style="color: #5a5e66;" class="m-0">
                    Study Background
                    <span class="ml-[10px] font-semibold text-rose-500" x-text="'( '+ data.name_khmer +' )'"></span>
                </h3>
                <span style="color: #5a5e66;" class="m-0 text-bold cursor-pointer" @click="$store.studyBackgroundDialog.close()"><i
                        data-feather="x"></i></span>
            </div>
            <div class="form-body p-0">
                <div class="table">
                    <div class="table-wrapper">
                        <div class="table-header">
                            <div class="row table-row-5">
                                <span>@lang('table.field.no')</span>
                            </div>
                            <div class="row table-row-20">
                                <span>Class Code</span>
                            </div>
                            <div class="row table-row-15">
                                <span>Processing</span>
                            </div>
                            <div class="row table-row-15">
                                <span>Practice Hour</span>
                            </div>
                            <div class="row table-row-15">
                                <span>Theory Hour</span>
                            </div>
                            <div class="row table-row-15">
                                <span>Practiced Hour</span>
                            </div>
                            <div class="row table-row-15">
                                <span>Theoried Hour</span>
                            </div>
                        </div>
                        <div class="table-body overflow-hidden">
                            <template x-if="data.classes.length > 0">
                                <template x-for="(item, index) in data.classes">
                                    <div class="column">
                                        <div class="row table-row-5">
                                            <span x-text="Number(index) + 1"></span>
                                        </div>
                                        <div class="row table-row-20">
                                            <span x-text="item.class_code ?? '--'"></span>
                                        </div>
                                        <div class="row table-row-15">
                                            <span x-text="item?.class_status?.name"></span>
                                        </div>
                                        <div class="row table-row-15">
                                            <span
                                                x-text="item?.class_structure_program?.structure_program?.practice_hour"></span>
                                        </div>
                                        <div class="row table-row-15">
                                            <span
                                                x-text="item?.class_structure_program?.structure_program?.theory_hour"></span>
                                        </div>
                                        <div class="row table-row-15">
                                            <span
                                                x-text="Number(item?.class_structure_program?.structure_program?.attend_amount) * 3 >= Number(item?.class_structure_program?.structure_program?.practice_hour) ? Number(item?.class_structure_program?.structure_program?.practice_hour) : Number(item?.class_structure_program?.structure_program?.attend_amount) * 3"></span>
                                        </div>
                                        <div class="row table-row-15">
                                            <span
                                                x-text="Number(item?.class_structure_program?.structure_program?.attend_amount) * 3 >= Number(item?.class_structure_program?.structure_program?.practice_hour) ? item?.class_structure_program?.structure_program?.theory_hour : '--'"></span>
                                        </div>
                                    </div>
                                </template>
                            </template>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
    <script>
        Alpine.data('studyBackgroundDialog', () => ({
            data: null,
            init() {
                this.data = JSON.parse(this.$store.studyBackgroundDialog.data);
                console.log(this.data);
            },
        }));
    </script>
@endcomponent
