<div class="table">
    @if ($data->count() > 0)
        <div class="table-wrapper">
            <div class="table-header">
                <div class="row table-row-5">
                    <span>@lang('table.field.no')</span>
                </div>
                <div class="row table-row-10">
                    <span>@lang('table.field.profile')</span>
                </div>
                <div class="row table-row-15">
                    <span>Name Lating</span>
                </div>
                <div class="row table-row-15">
                    <span>Name Khmer</span>
                </div>
                <div class="row table-row-10">
                    <span>Student ID</span>
                </div>
                <div class="row table-row-15">
                    <span>Education</span>
                </div>
                <div class="row table-row-15">
                    <span>@lang('table.field.phone')</span>
                </div>
                <div class="row table-row-10">
                    <span>Approval Status</span>
                </div>
                <div class="row table-row-5">
                    <span></span>
                </div>
            </div>
            <div class="table-body">
                @foreach ($data as $index => $item)
                    <div class="column">
                        <div class="row table-row-5">
                            <span>{!! $data->currentPage() * $data->perPage() - $data->perPage() + ($index + 1) !!}</span>
                        </div>
                        <div class="row table-row-10">
                            <div class="thumbnail" data-fancybox
                                data-src="{{ asset('file_manager' . $item->profile) }}">
                                <img style="object-fit: contain" src="{!! $item->profile != null ? asset('file_manager' . $item->profile) : asset('images/logo/default.png') !!}"
                                    onerror="(this).src='{{ asset('images/logo/default.png') }}'" alt="">
                            </div>
                        </div>
                        <div class="row table-row-15">
                            <span>{{ $item->name_latin ?? '--' }}</span>
                        </div>
                        <div class="row table-row-15">
                            <span>{{ $item->name_khmer ?? '--' }}</span>
                        </div>
                        <div class="row table-row-10">
                            <span>{{ $item->sid ?? '--' }}</span>
                        </div>
                        <div class="row table-row-15">
                            <span>{{ $item?->education_level?->name }}</span>
                        </div>
                        <div class="row table-row-15">
                            <span>{{ $item->phone }}</span>
                        </div>
                        <div class="row table-row-10" style="text-transform: capitalize">
                            <span>{{ $item->approval_status ?? '--' }}</span>
                        </div>
                        <div class="row table-row-5">
                            @if($item->approval_status != 'rejected')
                                @canany(['student-update', 'student-view-info', 'student-assign'])
                                    <div class="dropdown">
                                        <i data-feather="more-vertical" class="action-btn" id="dropdownMenuButton"
                                            data-mdb-toggle="dropdown" aria-expanded="false">
                                        </i>
                                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                            @if($item->approval_status == 'approved')
                                                @can('student-view-info')
                                                    <li>
                                                        <a class="dropdown-item" s-click-link="{!! route('admin-student-view', $item->id) !!}">
                                                            <i data-feather="monitor"></i>
                                                            <span>View Info</span>
                                                        </a>
                                                    </li>
                                                @endcan
                                                @if (count($item->classes))
                                                    @can('student-view-info')
                                                        <li @click="openStudyBackgroundDialog('{{ $item }}')">
                                                            <a class="dropdown-item">
                                                                <i data-feather="activity"></i>
                                                                <span>Study Background</span>
                                                            </a>
                                                        </li>
                                                    @endcan
                                                @endif
                                                @can('student-update')
                                                    <li>
                                                        <a class="dropdown-item" s-click-link="{!! route('admin-student-create', $item->id) !!}">
                                                            <i data-feather="edit"></i>
                                                            <span>@lang('table.option.edit')</span>
                                                        </a>
                                                    </li>
                                                    @if ($item->status == 1)
                                                        <li>
                                                            <a class="dropdown-item disable-btn"
                                                                onclick="$onConfirmMessage(
                                                                '{!! route('admin-student-status', ['id' => $item->id, 'status' => 2]) !!}',
                                                                '@lang('dialog.msg.disable', ['name' => $item->name])',
                                                                {
                                                                    confirm: '@lang('dialog.button.disable')',
                                                                    cancel: '@lang('dialog.button.cancel')'
                                                                }
                                                            );">
                                                                <i data-feather="x-circle"></i>
                                                                <span>Disable</span>
                                                            </a>
                                                        </li>
                                                    @else
                                                        <li>
                                                            <a class="dropdown-item enable-btn"
                                                                onclick="$onConfirmMessage(
                                                                '{!! route('admin-student-status', ['id' => $item->id, 'status' => 1]) !!}',
                                                                '@lang('dialog.msg.enable', ['name' => $item->name])',
                                                                {
                                                                    confirm: '@lang('dialog.button.enable')',
                                                                    cancel: '@lang('dialog.button.cancel')'
                                                                },
                                                            );">
                                                                <i data-feather="rotate-ccw"></i>
                                                                <span>Enable</span>
                                                            </a>
                                                        </li>
                                                    @endif
                                                @endcan
                                                @can('student-assign')
                                                    <li>
                                                        <a class="dropdown-item" s-click-link="{!! route('admin-student-assign-class', $item->id) !!}">
                                                            <i data-feather="edit"></i>
                                                            <span>Assign Class</span>
                                                        </a>
                                                    </li>
                                                @endcan
                                            @else
                                                @can('student-update')
                                                    @if ($item->approval_status == 'pending')
                                                        <li>
                                                            <a class="dropdown-item disable-btn"
                                                                onclick="$onConfirmMessage(
                                                                '{!! route('admin-student-approval-status', ['id' => $item->id, 'approval_status' => 'rejected']) !!}',
                                                                'Are you sure you want to <b>reject</b> register student <b> {{$item->name_latin}} </b> ?',
                                                                {
                                                                    confirm: 'Reject',
                                                                    cancel: 'Close'
                                                                }
                                                            );">
                                                                <i data-feather="x"></i>
                                                                <span>Reject</span>
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a class="dropdown-item enable-btn"
                                                                onclick="$onConfirmMessage(
                                                                '{!! route('admin-student-approval-status', ['id' => $item->id, 'approval_status' => 'approved']) !!}',
                                                                'Are you sure you want to <b>approve</b> register student <b> {{$item->name_latin}} </b> ?',
                                                                {
                                                                    confirm: 'Approve',
                                                                    cancel: 'Close'
                                                                },
                                                            );">
                                                                <i data-feather="check"></i>
                                                                <span>Approve</span>
                                                            </a>
                                                        </li>
                                                    @endif
                                                @endcan
                                            @endif  
                                        </ul>
                                    </div>
                                @endcan
                            @endif
                        </div>
                    </div>
                @endforeach

            </div>
            <div class="table-footer">
                @include('admin::components.pagination', ['paginate' => $data])
            </div>
        </div>
    @else
        @component('admin::components.empty', [
            'name' => 'Student is empty',
            'msg' => 'You can create a new Student by clicking the button below.',
            'permission' => 'student-create',
            'url' => route('admin-student-create'),
            'button' => 'Create New Student',
        ])
        @endcomponent
    @endif
</div>
