@extends('admin::pages.teacherPortal.index')
@section('teacher')
<div class="p-3">
    <div class="w-100 mb-4">
        <button s-click-link="{{route('admin-teacher-portal-list')}}" class="mt-2 w-100 bg-danger text-align-center"
            style="height: 30px; border-radius: 4px;">
            <span class="w-100 text-light">ថយក្រោយ</span>
        </button>
    </div>
    <div>
        <div style="text-align: center">
            <span>
                សិស្សដែលមានវត្តមានសម្រាប់ថ្ងៃនេះ
            </span>
        </div>
        <div style="text-align: center">
            <span>
                {{$today}}
            </span>
        </div>
        @if(count($data) > 0)
        @foreach($data as $value)
        <div class="mt-5 d-flex justify-content-between align-items-center">
            <div>
                <span>Lesson:</span>
                <span class="font-weight-bolder">
                    {{$value->lessons->short_name ?? ''}} -
                    {{$value->lessons->name ?? ''}}
                </span>
            </div>
            <button
                s-click-link="{{route('admin-teacher-portal-create',['class_id' => request('class_id'), 'id' => $value->id])}}"
                class="bg-primary w-auto" style="border-radius: 4px; height 30px">
                <span class="text-light">
                    កែប្រែ
                </span>
            </button>
        </div>
        <div class="content-body mb-3">
            <div class="table" style="border-bottom: 1px solid #4f4f4f;">
                <div class="table-wrapper">
                    <div class="table-header" style="background: #4f4f4f">
                        <div class="row table-row-10">
                            <span class="text-light">
                                លេខរៀង
                            </span>
                        </div>
                        <div class="row table-row-10">
                            <span class="text-light">
                                អត្តលេខ
                            </span>
                        </div>
                        <div class="row table-row-30">
                            <span class="text-light">
                                ឈ្មោះសិស្ស
                            </span>
                        </div>
                        <div class="row table-row-10">
                            <span class="text-light">
                                ភេទ
                            </span>
                        </div>
                        <div class="row table-row-15">
                            <span class="text-light">
                                វត្តមាន
                            </span>
                        </div>
                        <div class="row table-row-25">
                            <span class="text-light">
                                រូបភាព
                            </span>
                        </div>
                    </div>
                    <div class="table-body overflow-auto">
                        @foreach($students as $index => $item)
                        <div class="column h-col">
                            <div class="row table-row-10">
                                <span style="color: #4f4f4f">
                                    {{$index + 1}}
                                </span>
                            </div>
                            <div class="row table-row-10">
                                <span style="color: #4f4f4f">
                                    {{$item->sid ?? '--'}}
                                </span>
                            </div>
                            <div class="row table-row-30">
                                <span style="color: #4f4f4f">
                                    {{$item->name_khmer ?? '--'}}
                                </span>
                            </div>
                            <div class="row table-row-10">
                                <span style="color: #4f4f4f">
                                    {{$item->gender ?? '--'}}
                                </span>
                            </div>
                            <div class="row table-row-15">
                                <span style="color: #4f4f4f"
                                    class="{{$value->student_id?in_array($item->id, $value->student_id) ? 'text-success' : 'text-danger': 'text-danger'}}">
                                    {{$value->student_id?in_array($item->id, $value->student_id) ? 'Yes' : 'No' : 'No'}}
                                </span>
                            </div>
                            <div class="row table-row-25">
                                <div class="thumbnail photo" data-fancybox
                                    data-src="{{ asset('file_manager' . $item->profile)  }}">
                                    <img src="{!! $item->profile != null ? asset('file_manager' . $item->profile) : asset('images/logo/default.png') !!}"
                                        onerror="(this).src='{{ asset('images/logo/default.png') }}'" alt=""
                                        style="width: 3cm; object-fit:contain;">
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
        @endforeach
        @else
        <div style="text-align: center">
            <span class="text-danger font-weight-bolder">
                No Data!
            </span>
        </div>
        @endif
    </div>
</div>
@stop