@extends('admin::pages.teacherPortal.index')
@section('teacher')
<div class="form-admin" x-data="xCreateAttendance">
    <form id="form" class="form-wrapper p-0" action="{!! route('admin-teacher-portal-save', request('id')) !!}"
        method="POST" enctype="multipart/form-data">
        <div class="row p-3">
            <div class="mt-2 w-100 bg-danger d-flex justify-content-center align-items-center cursor-pointer"
                style="height: 30px; border-radius: 4px;" s-click-link="{{ route('admin-teacher-portal-list') }}">
                <span class="w-100 text-light d-flex justify-content-center align-items-center">ថយក្រោយ</span>
            </div>
        </div>
        {{ csrf_field() }}
        <div class="form-body p-3">
            <div class="row">
                <div class="form-row">
                    <label for="class">លេខកូដថ្នាក់</label>
                    <select name="class_id" id="class">
                        <option value="{!! request('class_id') !!}">
                            {!! request('class_id') !!}
                        </option>
                    </select>
                </div>
            </div>
            <div class="row">
                <div class="form-row">
                    <label>
                        សូមជ្រើសរើសមុខវិជ្ជា
                    </label>
                    <select name="lesson_id">
                        <option value="">សូមជ្រើសរើស...</option>
                        @foreach($lessons as $lesson)
                        @if(in_array($lesson->id, $lessons_id))
                        <option value="{{$lesson->id}}" {{request('id') ? $attendance->lesson_id == $lesson->id ?
                            'selected' : '': ''}}>
                            {{$lesson->short_name.'-'.$lesson->name}}
                        </option>
                        @endif
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="row">
                <div class="form-row">
                    <label>
                        សូមជ្រើសរើសប្រអប់ខាងក្រោម
                    </label>
                    <div class="table">
                        <span class="d-flex justify-content-center align-items-center">
                            បញ្ជីឈ្មោះសិស្ស
                        </span>
                        <div>
                            <template x-if="selectAll">
                                <span style="padding: 10px; border-radius: 4px"
                                    class="cursor-pointer bg-primary text-light" @click="toggleAllCheckboxes()">
                                    ដោះធីកទាំងអស់
                                </span>
                            </template>
                            <template x-if="!selectAll">
                                <span style="padding: 10px; border-radius: 4px"
                                    class="cursor-pointer bg-primary text-light" @click="toggleAllCheckboxes()">
                                    ធីកទាំងអស់
                                </span>
                            </template>
                        </div>
                        <div class=" table-wrapper">
                            <div class="table-header text-light" style="background: #4f4f4f">
                                <div class="row table-row-20">
                                    <span>គូសវត្តមាន</span>
                                </div>
                                <div class="row table-row-20">
                                    <span>លេខរៀង</span>
                                </div>
                                <div class="row table-row-35">
                                    <span>ឈ្មោះសិស្ស</span>
                                </div>
                                <div class="row table-row-25">
                                    <span>រូបភាព</span>
                                </div>
                            </div>
                            <div class="table-body overflow-auto w-auto">
                                @foreach($students as $index => $student)
                                <div class="column h-col">
                                    <div class="row table-row-20">
                                        <span class="d-flex justify-content-center align-items-center">
                                            <input type="checkbox" name="student_id[]" class="item-select-input"
                                                value="{{ $student->id }}" {{request('id')? $attendance->student_id ?
                                            in_array($student->id,$attendance->student_id)
                                            ? 'checked' : '' : '' : ''}}>
                                        </span>
                                    </div>
                                    <div class="row table-row-20">
                                        <span>
                                            {{$index+1}}
                                        </span>
                                    </div>
                                    <div class="row table-row-35">
                                        <span>
                                            {{$student->name_khmer ?? '--'}}
                                        </span>
                                    </div>
                                    <div class="row table-row-25">
                                        <div class="thumbnail photo" data-fancybox
                                            data-src="{{ asset('file_manager' . $student->profile)  }}">
                                            <img src="{!! $student->profile != null ? asset('file_manager' . $student->profile) : asset('images/logo/default.png') !!}"
                                                onerror="(this).src='{{ asset('images/logo/default.png') }}'" alt=""
                                                style="width: 3cm; object-fit:contain;">
                                        </div>
                                    </div>
                                </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row mb-5">
                @if(in_array(auth()->user()->id, $user_checked))
                <button style="height: 30px;" type="submit" class="btn-create bg-primary w-100" s-click-link="">
                    <span class="w-100">
                        បញ្ចូលទិន្នន័យ
                    </span>
                </button>
                @endif
                <div class="mt-2 w-100 bg-primary d-flex justify-content-center align-items-center cursor-pointer"
                    style="height: 30px; border-radius: 4px;"
                    s-click-link="{{ route('admin-teacher-portal-attend', request('class_id')) }}">
                    <span class=" text-light w-100 d-flex justify-content-center align-items-center">
                        បង្ហាញទិន្នន័យដែលបានបញ្ចូលថ្ងៃនេះ
                    </span>
                </div>
            </div>
        </div>
    </form>
</div>
@stop

@section('script')
<script>
    Alpine.data('xCreateAttendance', () => ({
        selectAll : false, 
        selectStudents: [],
        toggleAllCheckboxes() {
            this.selectAll = !this.selectAll
            this.selectStudents = [];

            checkboxes = document.querySelectorAll('.item-select-input');
            [...checkboxes].map((el) => {
                el.checked = this.selectAll;
                (this.selectAll) ? this.selectStudents.push(el.value) : this.selectStudents = [];
            })
        },
    }));
</script>
@stop