@extends('admin::pages.teacherPortal.index')
@section('teacher')
<div class="p-3">
    <div class="w-100 mb-4">
        <button s-click-link="{{route('admin-teacher-portal-list')}}" class="mt-2 w-100 bg-danger text-align-center"
            style="height: 30px; border-radius: 4px;">
            <span class="w-100 text-light">ថយក្រោយ</span>
        </button>
    </div>
    <div>
        <div style="text-align: center">
            <span>
                បញ្ជីឈ្មោះសិស្ស
            </span>
        </div>
        <div>
            <span>
                លេខកូដថ្នាក់: <span>{{request('class_id')}}</span>
            </span>
        </div>
        <div>
            <span>
                សិស្សសរុប: <span>{{$count}}</span>
            </span>
        </div>
        @if(count($data) > 0)
        <div class="content-body mb-3">
            <div class="table">
                <div class="table-wrapper">
                    <div class="table-header text-light" style="background: #4f4f4f">
                        <div class="row table-row-10">
                            <span class="font-sm">លេខ​កូដ​ក្រុម</span>
                        </div>
                        <div class="row table-row-40">
                            <span class="font-sm">ឈ្មោះ​ក្រុម</span>
                        </div>
                        <div class="row table-row-10">
                            <span class="font-sm">លេខរៀង</span>
                        </div>
                        <div class="row table-row-40">
                            <span class="font-sm">ឈ្មោះសិស្ស</span>
                        </div>
                    </div>
                    <div class="table-body overflow-auto">
                        @foreach($data as $item)
                        <div class="column h-auto">
                            <div class="row table-row-10">
                                <span class="font-sm">
                                    {{$item->id}}
                                </span>
                            </div>
                            <div class="row table-row-40">
                                <span class="font-sm">
                                    {{$item->name}}
                                </span>
                            </div>
                            <div class="row table-row-10">
                                @foreach($item->students as $index => $student)
                                <span class="font-sm">
                                    <div class="column h-auto">
                                        <div class="row">
                                            <span>
                                                {{$index+1}}
                                            </span>
                                        </div>
                                    </div>
                                </span>
                                @endforeach
                            </div>
                            <div class="row table-row-40">
                                @foreach($item->students as $index => $student)
                                <span class="font-sm">
                                    <div class="column h-auto">
                                        <div class="row">
                                            <span>
                                                {{$student->name_khmer}}
                                            </span>
                                        </div>
                                    </div>
                                </span>
                                @endforeach
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
        @else
        <div style="text-align: center">
            <span class="text-danger font-weight-bolder">
                No Data!
            </span>
        </div>
        @endif
    </div>
</div>
@stop