<div class="table">
    @if ($data->count() > 0)
    <div class="table-wrapper">
        <div class="table-header">
            <div class="row table-row-5">
                <span>Nº</span>
            </div>
            <div class="row table-row-10">
                <span>Image</span>
            </div>
            <div class="row table-row-15">
                <span>Name</span>
            </div>
            <div class="row table-row-15">
                <span>Skill</span>
            </div>
            <div class="row table-row-10">
                <span>Certified</span>
            </div>
            <div class="row table-row-10">
                <span>Popular</span>
            </div>
            <div class="row table-row-10">
                <span>Experience</span>
            </div>
            <div class="row table-row-10">
                <span>Work</span>
            </div>
            <div class="row table-row-10">
                <span>Position </span>
            </div>
            <div class="row table-row-5">
                <span></span>
            </div>
        </div>
        <div class="table-body">
            @foreach ($data as $index => $item)
            <div class="column">
                <div class="row table-row-5">
                    <span>{!! $data->currentPage() * $data->perPage() - $data->perPage() + ($index + 1) !!}</span>
                </div>
                <div class="row table-row-10">
                    <div class="thumbnail" data-fancybox data-src="{{ asset('file_manager' . $item->profile)  }}">
                        <img src="{!! $item->profile != null ? asset('file_manager' . $item->profile) : asset('images/logo/default.png') !!}"
                            onerror="(this).src='{{ asset('images/logo/default.png') }}'" alt="">
                    </div>
                </div>
                <div class="row table-row-15">
                    <span>{{$item->name ?? '--'}}</span>
                </div>
                <div class="row table-row-15">
                    <span>{{$item->skill ?? '--'}}</span>
                </div>
                <div class="row table-row-10">
                    <span class="d-flex justify-content-center align-items-center">
                        @if($item->certified && $item->certified == 1)
                        <i class="text-success" data-feather="check-circle"></i>
                        @else
                        <i class="text-danger" data-feather="x-circle"></i>
                        @endif
                    </span>
                </div>
                <div class="row table-row-10">
                    <span class="d-flex justify-content-center align-items-center">
                        @if($item->popular && $item->popular == 1)
                        <i class="text-success" data-feather="check-circle"></i>
                        @else
                        <i class="text-danger" data-feather="x-circle"></i>
                        @endif
                    </span>
                </div>
                <div class="row table-row-10">
                    <span>{{$item->experience ?? '--'}} year(s)</span>
                </div>
                <div class="row table-row-10">
                    <span>{{$item->work ?? '--'}}</span>
                </div>
                <div class="row table-row-10">
                    <span>{{ucfirst($item->position ?? '--')}} </span>
                </div>
                <div class="row table-row-5">
                    @canany(['trainer-update'])
                    <div class="dropdown">
                        <i data-feather="more-vertical" class="action-btn" id="dropdownMenuButton"
                            data-mdb-toggle="dropdown" aria-expanded="false">
                        </i>
                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                            @if ($item->status != 'trash')
                            @can('trainer-update')
                            <li>
                                <a class="dropdown-item"
                                    s-click-link="{!! route('admin-trainer-create', $item->id) !!}">
                                    <i data-feather="edit"></i>
                                    <span>Edit</span>
                                </a>
                            </li>
                            @if ($item->status == 2)
                            <li>
                                <a class="dropdown-item enable-btn" onclick="$onConfirmMessage(
                                    '{!! route('admin-trainer-status', ['id' => $item->id, 'status' => 1]) !!}',
                                    '@lang('dialog.msg.enable', ['name' => $item->title])',
                                    {
                                        confirm: '@lang('dialog.button.enable')',
                                        cancel: '@lang('dialog.button.cancel')'
                                    },
                                );">
                                    <i data-feather="rotate-ccw"></i>
                                    <span>Enable</span>
                                </a>
                            </li>
                            @else
                            <li>
                                <a class="dropdown-item disable-btn" onclick="$onConfirmMessage(
                                    '{!! route('admin-trainer-status', ['id' => $item->id, 'status' => 2]) !!}',
                                    '@lang('dialog.msg.disable', ['name' => $item->title])',
                                    {
                                        confirm: '@lang('dialog.button.disable')',
                                        cancel: '@lang('dialog.button.cancel')'
                                    }
                                );">
                                    <i data-feather="x-circle"></i>
                                    <span>Disable</span>
                                </a>
                            </li>
                            @endif
                            @endcan
                            @endif
                        </ul>
                    </div>
                    @endcan
                </div>
            </div>
            @endforeach
        </div>
        <div class="table-footer">
            @include('admin::components.pagination', ['paginate' => $data])
        </div>
    </div>
    @else
    @component('admin::components.empty',
    [
    'name' => 'Trainer is empty',
    'msg' => 'You can create a new trainer by clicking the button below.',
    'permission' => 'trainer-create',
    'url' => route('admin-trainer-create'),
    'button' => 'Create Trainer',
    ])
    @endcomponent
    @endif
</div>