@extends('admin::shared.layout')
@section('layout')
<div class="form-admin">
    <div class="form-bg"></div>
    <form id="form" class="form-wrapper" action="{!! route('admin-work-day-save', request('id'))!!}" method="POST"
        enctype="multipart/form-data">
        <div class="form-header">
            <h3>
                Work Day
            </h3>
        </div>
        {{ csrf_field() }}
        <div class="form-body">
            <div class="row-2">
                <div class="form-row">
                    <label>Day<span>*</span></label>
                    <select name="day" id="">
                        <option value="">Select Day</option>
                        @foreach($days as $day)
                        <option value="{{$day}}">{{$day}}</option>
                        @endforeach
                    </select>
                    @error('day')
                    <label class="error">{{ $message }}</label>
                    @enderror
                </div>
                <div class="form-row">
                    <label>Status<span>*</span></label>
                    <select name="status" id="">
                        <option value="1" {{request('id') && $data->status == 1 ? 'selected' : old('status')}}>Active
                        </option>
                        <option value="1" {{request('id') && $data->status == 2 ? 'selected' : old('status')}}>Disable
                        </option>
                    </select>
                    @error('title')
                    <label class="error">{{ $message }}</label>
                    @enderror
                </div>
            </div>
            <div class="row-2">
                <div class="form-row">
                    <label>From Hour<span>*</span></label>
                    <input type="time" name="from_hour" placeholder=""
                        value="{!! request('id') ? $data->from_hour : old('from_hour') !!}">
                    @error('from_hour')
                    <label class="error">{{ $message }}</label>
                    @enderror
                </div>
                <div class="form-row">
                    <label>To Hour<span>*</span></label>
                    <input type="time" name="to_hour" placeholder=""
                        value="{!! request('id') ? $data->to_hour : old('to_hour') !!}">
                    @error('to_hour')
                    <label class="error">{{ $message }}</label>
                    @enderror
                </div>
            </div>
            <div class="row-2">
                <div class="form-row">
                    <label>Order</label>
                    <input type="number" name="order" placeholder=""
                        value="{!! request('id') ? $data->order : $order+1 !!}">
                    @error('order')
                    <label class="error">{{ $message }}</label>
                    @enderror
                </div>
            </div>
            <div class="form-button">
                <button type="submit" color="primary">
                    <i data-feather="save"></i>
                    <span>Submit</span>
                </button>
                <button color="danger" type="button" s-click-link="{!! route('admin-work-day-list', 1) !!}">
                    <i data-feather="x"></i>
                    <span>Cancel</span>
                </button>
            </div>
        </div>
        <div class="form-footer"></div>
    </form>
</div>
@include('admin::file-manager.popup')
@stop
@section('script')
<script>
    $(document).ready(function() {
        $validator("#form", {
            day: {
                required: true,
            },
            from_hour: {
                required: true,
            },
            to_hour: {
                required: true,
            },
        });
    });
    function selectImage(e) {
            fileManager({
                multiple: false,
                afterClose: (data, basePath) => {
                    if (data?.length > 0) {
                        const parent = e.target.closest('.form-select-photo');
                        e.target.value = data[0].path;
                        parent
                            .querySelector('.select-photo')
                            .classList.add('active');
                        parent
                            .querySelector('.image-view')
                            .classList
                            .add('active');
                        parent
                            .querySelector('.image-view')
                            .childNodes[0]
                            .nextElementSibling
                            .setAttribute('src', basePath + data[0].path);
                    }
                }
            })
        }
</script>
@stop