<div class="table">
    @if ($data->count() > 0)
    <div class="table-wrapper">
        <div class="table-header">
            <div class="row table-row-5">
                <span>Nº</span>
            </div>
            <div class="row table-row-30">
                <span>Day</span>
            </div>
            <div class="row table-row-25">
                <span>From Hour</span>
            </div>
            <div class="row table-row-25">
                <span>To Hour</span>
            </div>
            <div class="row table-row-10">
                <span>Ordering</span>
            </div>
            <div class="row table-row-5">
                <span></span>
            </div>
        </div>
        <div class="table-body">
            @foreach ($data as $index => $item)
            <div class="column">
                <div class="row table-row-5">
                    <span>{!! $data->currentPage() * $data->perPage() - $data->perPage() + ($index + 1) !!}</span>
                </div>
                <div class="row table-row-30">
                    <span>{{$item->day ?? '--'}}</span>
                </div>
                <div class="row table-row-25">
                    <span>{{date('h:i a',strtotime($item->from_hour)) ?? '--'}}</span>
                </div>
                <div class="row table-row-25">
                    <span>{{date('h:i a',strtotime($item->to_hour)) ?? '--'}}</span>
                </div>
                <div class="row table-row-10">
                    <span>{{ $item->order ?? '--' }}</span>
                </div>
                <div class="row table-row-5">
                    @canany(['work-day-update'])
                    <div class="dropdown">
                        <i data-feather="more-vertical" class="action-btn" id="dropdownMenuButton"
                            data-mdb-toggle="dropdown" aria-expanded="false">
                        </i>
                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                            @if ($item->status != 'trash')
                            @can('work-day-update')
                            <li>
                                <a class="dropdown-item"
                                    s-click-link="{!! route('admin-work-day-create', $item->id) !!}">
                                    <i data-feather="edit"></i>
                                    <span>Edit</span>
                                </a>
                            </li>
                            @if ($item->status == 2)
                            <li>
                                <a class="dropdown-item enable-btn" onclick="$onConfirmMessage(
                                    '{!! route('admin-work-day-status', ['id' => $item->id, 'status' => 1]) !!}',
                                    '@lang('dialog.msg.enable', ['name' => $item->day])',
                                    {
                                        confirm: '@lang('dialog.button.enable')',
                                        cancel: '@lang('dialog.button.cancel')'
                                    },
                                );">
                                    <i data-feather="rotate-ccw"></i>
                                    <span>Enable</span>
                                </a>
                            </li>
                            @else
                            <li>
                                <a class="dropdown-item disable-btn" onclick="$onConfirmMessage(
                                    '{!! route('admin-work-day-status', ['id' => $item->id, 'status' => 2]) !!}',
                                    '@lang('dialog.msg.disable', ['name' => $item->day])',
                                    {
                                        confirm: '@lang('dialog.button.disable')',
                                        cancel: '@lang('dialog.button.cancel')'
                                    }
                                );">
                                    <i data-feather="x-circle"></i>
                                    <span>Disable</span>
                                </a>
                            </li>
                            @endif
                            @endcan
                            @endif
                        </ul>
                    </div>
                    @endcan
                </div>
            </div>
            @endforeach
        </div>
        <div class="table-footer">
            @include('admin::components.pagination', ['paginate' => $data])
        </div>
    </div>
    @else
    @component('admin::components.empty',
    [
    'name' => 'Work Day is empty',
    'msg' => 'You can create a new work day by clicking the button below.',
    'permission' => 'work-day-create',
    'url' => route('admin-work-day-create'),
    'button' => 'Create Work Day',
    ])
    @endcomponent
    @endif
</div>