<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="csrf-token" content="{{ csrf_token() }}" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@lang('LICE') @yield('LICE')</title>
    @yield('meta')
    <link rel="shortcut icon" href="{{ asset('website/images/logo/LICE_serge_comtesse_cambodia_black.png') }}" type="image/x-icon">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.3.0/css/all.min.css"
        integrity="sha512-SzlrxWUlpfuzQ+pcUCosxcglQRNAq/DZjVsC0lE40xsADsfeQoEypE+enwcOiGjk/bSuGGKHEyjSoQ1zVisanQ=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    {!! HTML::style('website/styles/css/app.css') !!}
    {!! HTML::script('website/styles/js/app.js') !!}

</head>

<body>

    @yield('index')
    <div x-data="{}">
        @include('website::components.toast')
    </div>
    @yield('script')

    {!! HTML::script('website/styles/js/body.js') !!}
    <script>
        $('.btnSignOut').click(function() {
            Swal.fire({
                title: 'Are you sure if you want to sign out?',
                type: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes',
                cancelButtonText: 'Cancel',
                showLoaderOnConfirm: true,
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = $(this).attr('data-url');
                }
            })
        });
    </script>

</body>

</html>
