@extends('shared.layout')
@section('content')
    <section class="gap-section">
        <div class="signin-signup container">
            <div class="border-wrapper">
                <div class="border" style="border-bottom: 1px solid yellow"></div>
                <h3 class="text-3xl text-yellow-500 uppercase">
                    Sign In / Sign Up
                </h3>
                <div class="border" style="border-bottom: 1px solid yellow"></div>
            </div>
            <div class="contain-signup mt-10">
                <div class="container-auth ">
                    <!-- content sign in -->
                    <div class="content-auth sign-in" x-data="form">
                        <div class="back">
                            <div class="item" style="padding-bottom: 20px;">
                                <div class="contain-item" style="padding-top: 10px;">
                                    <div class="trainer-detail mt-5 mb-10">
                                        <div class="title">
                                            <h4>Sign In</h4>
                                        </div>
                                    </div>
                                    <form action="{{ route('website-auth-access-sign-in') }}" method="post"
                                        x-form="submit">
                                        @csrf
                                        <input type="hidden" name="returnUrl" value="{{ request('returnUrl') }}">
                                        <div class="input">
                                            <div class="form-group">
                                                <input placeholder="Email" type="text" name="email">
                                                <span class="text-red-600 text-xs mt-1" x-show="validate?.email"
                                                    x-text="validate?.email"></span>
                                            </div>
                                            <div class="form-group">
                                                <input placeholder="Password" type="password" name="password">
                                                <span class="text-red-600 text-xs mt-1" x-show="validate?.password"
                                                    x-text="validate?.password"></span>
                                            </div>
                                        </div>
                                        <div class="checkbox">
                                            <div class="flex justify-between">
                                                <input type="checkbox" name="remember" id="remember">
                                                <label class="ml-1" for="remember">Remember me</label>
                                            </div>
                                            <div>
                                                <a href="{{ route('website-auth-forgot-password', ['returnUrl' => request('returnUrl')]) }}"
                                                    class="text-yellow-600">Forget Password?</a>
                                            </div>
                                        </div>

                                        <div class="btn-trainer my-5 flex justify-center">
                                            <button type="submit">
                                                <span>Sign In</span>
                                            </button>
                                        </div>
                                    </form>
                                    <div class="text flex justify-between">
                                        <p>Don't have an account?</p>
                                        <div class="toggle-signup">
                                            <button class="ml-2 text-black font-[500]">
                                                <a
                                                    href="{{ route('website-auth-sign-up', ['returnUrl' => request('returnUrl')]) }}">
                                                    Sign up
                                                </a>
                                            </button>
                                        </div>

                                    </div>
                                </div>
                                <div class="login-with-label">
                                    <div class="line"></div>
                                    <span>Sign In With</span>
                                    <div class="line"></div>
                                </div>
                                <div class="login-with">
                                    <div class="facebook cursor-pointer" @click="authBySocial('facebook')">
                                        <div class="icon-facebook"><i class="fab fa-facebook-f"></i></div>
                                        <div class="name-facebook">
                                            <p>Facebook</p>
                                        </div>
                                    </div>
                                    <div class="google cursor-pointer" @click="authBySocial('google')">
                                        <div class="icon-google">
                                            <img alt=""
                                                src="https://img.icons8.com/color/144/000000/google-logo.png"
                                                width="20">
                                        </div>
                                        <span class="name-google">
                                            <p>Google</p>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="right-item">
                            <div class="contain-right-item">
                                <div class="right-image">
                                    <img src="{{ asset('images/p.jpeg') }}">
                                </div>
                                <div class="btn-signup">
                                    <div class="title">
                                        <h3>Create Account</h3>
                                    </div>
                                    <div class="text-right-item">
                                        <p>Enter your personal details and start journey with us</p>
                                    </div>
                                    <div class="btn-sign toggle-signup">
                                        <button>
                                            <a
                                                href="{{ route('website-auth-sign-up', ['returnUrl' => request('returnUrl')]) }}">
                                                Sign Up
                                            </a>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@stop
@section('script')
    {!! HTML::script('firebase/app.js') !!}
    {!! HTML::script('firebase/auth.js') !!}
    {!! HTML::script('firebase/firestore.js') !!}
    <script type="text/javascript">
        // Your web app's Firebase configuration
        var firebaseConfig = {
            apiKey: "AIzaSyA1fBNcCNZmhu4L9l2eBsPC6TcoFTADfu0",
            authDomain: "lice-b23df.firebaseapp.com",
            projectId: "lice-b23df",
            storageBucket: "lice-b23df.appspot.com",
            messagingSenderId: "578878065579",
            appId: "1:578878065579:web:5deac4828a146b4e21e0ee"
        };
        // Initialize Firebase
        firebase.initializeApp(firebaseConfig);
    </script>
    <script>
        Alpine.data("form", () => ({
            loading: false,
            validate: null,

            submit(response) {
                this.loading = response.loading;
                this.validate = response.data.errors;
                var data = response.data;

                if (data.error == false && response.completed == true) {
                    Toast({
                        message: data.message,
                        status: 'success',
                        size: 'small',
                    });

                    setTimeout(() => {
                        window.location.href = data?.redirectTo;
                    }, 1000);
                }

                if (data.error == true && response.completed == true) {
                    Toast({
                        message: data.message,
                        status: 'danger',
                        size: 'small',
                    });
                }

                this.loading = response.loading;
            },

            authBySocial(type) {
                let provider;
                if (type == 'facebook') {
                    provider = new firebase.auth.FacebookAuthProvider();
                } else {
                    provider = new firebase.auth.GoogleAuthProvider();
                }

                firebase.auth().signInWithPopup(provider).then(function(result) {
                    var token = result.credential.accessToken;
                    var user = result.user;

                    axios.post("{{ route('website-auth-social') }}", {
                        'name': user.displayName,
                        'email': user.email,
                        'phone': user.phoneNumber,
                        'profile': user.photoURL
                    }).then((response) => {
                        let data = response.data;
                        if (data.error == false) {
                            Toast({
                                message: data.message,
                                status: 'success',
                                size: 'small',
                            });

                            setTimeout(() => {
                                window.location.href = data?.redirectTo;
                            }, 1000);
                        }
                    });
                })
            }
        }));
    </script>
@stop
