@extends('shared.layout')
@section('content')
    <!-- Slide section -->
    @if (isset($slider) && count($slider) > 0)
        <div class="section-slide bg-black">
            <div class="swiper mySwiper">
                <div class="swiper-wrapper">
                    @foreach ($slider as $item)
                        <div class="swiper-slide">
                            <img src="{{ asset('file_manager' . $item?->image) }}" alt=""
                                onerror="this.onerror=null;this.src='{{ asset('website/images/logo/default.png') }}';">
                        </div>
                    @endforeach
                </div>
                <div class="swiper-pagination"></div>
            </div>
        </div>
    @endif

    <!-- Course -->
    @if (count($courses) > 0 || count($trainers) > 0 || count($professionals) > 0)
        @if (isset($courses) && count($courses) > 0)
            <div class="container course-page  bg-black" x-data="courseDialog">
                <div class="course-header-wrapper">
                    <div class="border-wrapper">
                        <div class="border" style="border-bottom: 1px solid yellow"></div>
                        <h3 class="text-3xl text-yellow-500">Course</h3>
                        <div class="border" style="border-bottom: 1px solid yellow"></div>
                    </div>
                </div>
                <div class="course-page-wrapper gap-x-8 gap-y-1 mt-5">
                    <!-- register-content -->
                    @foreach ($courses as $item)
                        <div class="course-page-wrapper-box p-2 register-content !w-full" id="register-content"
                            data-aos="fade-up" data-aos-duration="3000" x-data="{ show: true }">

                            <!-- course-content -->
                            <div class="course-content" x-show="show == true">
                                <div class="image-course w-1/2 ">
                                    <img src="{{ asset('file_manager' . $item?->image) }}" alt=""
                                        onerror="this.onerror=null;this.src='{{ asset('website/images/logo/default.png') }}';">
                                    <div class="btn-register">
                                        <button class="uppercase"
                                            @click="openRegisterDialog('{{ $item }}')">Register Now</button>
                                    </div>
                                </div>
                                <div class="detail-course w-1/2 ">
                                    <h2>
                                        {{ $item?->name }}
                                    </h2>
                                    <p>
                                        {{ $item?->description }}
                                    </p>
                                    <div class="dates mt-5">
                                        <span class="flex flex-row space-x-2">
                                            <i class="fas fa-calendar-alt text-yellow-500"></i>
                                            <span>{{ date('d-M-Y', strtotime($item?->created_at)) }}</span>
                                        </span>
                                    </div>
                                    <div class="day mb-2">
                                        <span class="flex flex-row space-x-2">
                                            <i class="far fa-calendar-check"></i>
                                            <h6>{{ $item?->duration }} day(s)</h6>
                                        </span>
                                    </div>
                                    <div class="price">
                                        <h3>{{ $item?->fee }}</h3>
                                    </div>
                                    <div class="btn-trainer" id="btn-trainer">
                                        <button class="uppercase" @click="show = false">Trainer</button>
                                    </div>
                                </div>
                            </div>

                            <!-- trainer-content -->
                            <div class="course-content" x-show="show == false">
                                <div class="cart mt-5">
                                    <div class="text-cart">
                                        <div class="title">
                                            <h4 class="text-yellow-600">{{ optional($item?->trainer)?->name }}</h4>
                                        </div>
                                        <div class="text">
                                            <div class="flex flex-col">
                                                <div class="flex flex-row space-x-2">
                                                    <p>Experience: </p>
                                                    <p>{{ optional($item?->trainer)?->experience }} year(s)</p>
                                                </div>
                                            </div>
                                            <div class="flex flex-col">
                                                <div class="flex flex-row space-x-14">
                                                    <p>Skill: </p>
                                                    <p>{{ optional($item?->trainer)->skill }}</p>
                                                </div>
                                            </div>
                                            <div class="flex flex-col">
                                                <div class="flex flex-row space-x-12">
                                                    <p>Work: </p>
                                                    <p>{{ optional($item?->trainer)->work }}</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="btn-trainer btn-course" id="btn-course">
                                            <button class="uppercase" @click="show = true">Course</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="image-course w-1/2 ">
                                    <img src="{{ asset('file_manager' . $item?->image) }}" alt=""
                                        onerror="this.onerror=null;this.src='{{ asset('website/images/logo/default.png') }}';">
                                    <div class="btn-register">
                                        <button class="uppercase"
                                            @click="openRegisterDialog('{{ $item }}')">Register Now</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
                @include('website::components.register-dialog')
            </div>
        @endif

        <!-- TRAINER PROFILE -->
        @if (isset($trainers) && count($trainers) > 0)
            <div class="container">
                <div class="trainer-section">
                    <div class="trainer-section-wrapper text-center mt-10">
                        <div class="border-wrapper">
                            <div class="border" style="border-bottom: 1px solid yellow"></div>
                            <h3 class="text-3xl text-yellow-500">TRAINER PROFILE</h3>
                            <div class="border" style="border-bottom: 1px solid yellow"></div>
                        </div>
                    </div>
                </div>
                <div class="trainer-section-profile mt-10">
                    <div class="trainer-section-profile-cart">
                        @foreach ($trainers->take(3) as $item)
                            <div class="cart-group" data-aos="fade-up" data-aos-duration="1000">
                                <div class="title-cart">
                                    <h4 class="text-2xl">COURSE</h4>
                                </div>
                                <div class="cart">
                                    <div class="img-cart">
                                        <img src="{{ asset('file_manager' . $item?->profile) }}" alt=""
                                            onerror="this.onerror=null;this.src='{{ asset('website/images/logo/default.png') }}';">
                                    </div>
                                    <div class="text-cart">
                                        <div class="title">
                                            <h4>{{ $item?->name }}</h4>
                                            <div class="border"></div>
                                        </div>
                                        <div class="text">
                                            <div class="flex flex-col">
                                                <div class="flex flex-row space-x-2">
                                                    <p>Experience: </p>
                                                    <p>{{ $item?->experience }} years</p>
                                                </div>
                                            </div>
                                            <div class="flex flex-col">
                                                <div class="flex flex-row space-x-14">
                                                    <p>Skill: </p>
                                                    <p>{{ $item?->skill }}</p>
                                                </div>
                                            </div>
                                            <div class="flex flex-col">
                                                <div class="flex flex-row space-x-12">
                                                    <p>Work: </p>
                                                    <p>{{ $item?->work }}</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="cart-hover"></div>
                            </div>
                        @endforeach
                    </div>
                    <div class="btn-more flex justify-center mt-16 mb-10">
                        <a href="{{ route('website-course-trainer') }}"
                            class="flex flex-row items-center rounded-full px-4 py-2">
                            <span>View More</span>
                            <i class="w-5 h-5" data-feather="arrow-down"></i>
                        </a>
                    </div>
                </div>
        </div>
        @endif

        <!-- PROFESSIONAL TEAMS -->
        @if (isset($professionals) && count($professionals) > 0)
            <div class="container  ">
                <div class="team-section">
                    <div class="team-section-wrapper">
                        <div class="border-wrapper">
                            <div class="border" style="border-bottom: 1px solid yellow"></div>
                            <h3 class="text-3xl text-yellow-500">PROFESSIONAL TEAMS</h3>
                            <div class="border" style="border-bottom: 1px solid yellow"></div>
                        </div>
                    </div>
                    <div class="team-section-profile">
                        <div class="team-section-profile-cart">
                            @foreach ($professionals as $item)
                                <div class="cart-group" data-aos="fade-up" data-aos-duration="1000">
                                    <div class="title-cart">
                                        <h4 class="text-2xl">COURSE</h4>
                                    </div>
                                    <div class="cart">
                                        <div class="img-cart">
                                            <img src="{{ asset('file_manager' . $item?->profile) }}" alt=""
                                                onerror="this.onerror=null;this.src='{{ asset('website/images/logo/default.png') }}';">
                                        </div>
                                        <div class="text-cart">
                                            <div class="title">
                                                <h4>{{ $item?->name }}</h4>
                                                <div class="border"></div>
                                            </div>
                                            <div class="text">
                                                <div class="flex flex-col">
                                                    <div class="flex flex-row space-x-2">
                                                        <p>Experience: </p>
                                                        <p>{{ $item?->experience }} years</p>
                                                    </div>
                                                </div>
                                                <div class="flex flex-col">
                                                    <div class="flex flex-row space-x-14">
                                                        <p>Skill: </p>
                                                        <p>{{ $item?->skill }}</p>
                                                    </div>
                                                </div>
                                                <div class="flex flex-col">
                                                    <div class="flex flex-row space-x-12">
                                                        <p>Work: </p>
                                                        <p>{{ $item?->work }}</p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="cart-hover">
                                        <div class="cart-list-text">
                                            <div class="cart-hover-title">
                                                {{-- <h4>MANAGEMENT : របៀបរៀបចំ និង ពង្រីកអាជីវកម្មសាឡនដោយអន្តរភាព</h4> --}}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        @endif
    @else
        @component('website::components.empty', [
            'title' => __('Empty Data'),
            'message' => __('No Data in this Page'),
            'image' => asset('images/empty.svg'),
            'style' => 'height: 300px; width: auto;',
        ])
        @endcomponent
    @endif

@stop
@section('script')
    <script>
        var swiper = new Swiper(".mySwiper", {
            effect: "fade",
            loop: true,
            speed: 1000,
            autoplay: {
                delay: 5000,
                disableOnInteraction: false,
            },
            pagination: {
                el: ".swiper-pagination",
                clickable: true,
            },
            grabCursor: true,
        });

        Alpine.data("courseDialog", () => ({
            isActive: 'course',

            switchToActive(type) {
                this.isActive = type
            },

            openRegisterDialog(data) {
                this.$store.registerDialog.open({
                    data: {
                        data: data
                    }
                })
            }
        }));
    </script>
@stop
