@extends('shared.layout')
@section('content')
    <!-- TRAINER PROFILE -->
    @if (isset($trainers) && count($trainers) > 0)
        <div class="container">
            <div class="trainer-section">
                <div class="trainer-section-wrapper text-center mt-10">
                    <div class="border-wrapper">
                        <div class="border" style="border-bottom: 1px solid yellow"></div>
                        <h3 class="text-3xl text-yellow-500">TRAINER PROFILE</h3>
                        <div class="border" style="border-bottom: 1px solid yellow"></div>
                    </div>
                </div>
            </div>
            <div class="trainer-section-profile mt-10">
                <div class="trainer-section-profile-cart">
                    @foreach ($trainers as $item)
                        <div class="cart-group" data-aos="fade-up" data-aos-duration="1000">
                            <div class="title-cart">
                                <h4 class="text-2xl">COURSE</h4>
                            </div>
                            <div class="cart">
                                <div class="img-cart">
                                    <img src="{{ asset('file_manager' . $item?->profile) }}" alt=""
                                        onerror="this.onerror=null;this.src='{{ asset('website/images/logo/default.png') }}';">
                                </div>
                                <div class="text-cart">
                                    <div class="title">
                                        <h4>{{ $item?->name }}</h4>
                                        <div class="border"></div>
                                    </div>
                                    <div class="text">
                                        <div class="flex flex-col">
                                            <div class="flex flex-row space-x-2">
                                                <p>Experience: </p>
                                                <p>{{ $item?->experience }} years</p>
                                            </div>
                                        </div>
                                        <div class="flex flex-col">
                                            <div class="flex flex-row space-x-14">
                                                <p>Skill: </p>
                                                <p>{{ $item?->skill }}</p>
                                            </div>
                                        </div>
                                        <div class="flex flex-col">
                                            <div class="flex flex-row space-x-12">
                                                <p>Work: </p>
                                                <p>{{ $item?->work }}</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="cart-hover"></div>
                        </div>
                    @endforeach
                </div>
                @include('website::components.pagination', ['data' => $trainers])
            </div>
        </div>
    @endif
@stop
