@extends('shared.layout')
@section('content')
    <!-- photo Album -->
    <div class="container gallery-container">
        <div class="border-wrapper">
            <div class="border" style="border-bottom: 1px solid yellow"></div>
            <h3 class="text-3xl text-yellow-500 ">
                {{ $photo_details['album']?->name }}
            </h3>
            <div class="border" style="border-bottom: 1px solid yellow"></div>
        </div>
        @if (isset($photo_details['galleries']) && count($photo_details['galleries']) > 0)
            <div class="group-photo">
                @foreach ($photo_details['galleries'] as $item)
                    <div class="card-photo cursor-pointer">
                        <div data-fancybox="gallery" data-src="{{ asset('file_manager' . $item?->image) }}">
                            <div class="img ">
                                <img alt="" src="{{ asset('file_manager' . $item?->image) }}" onerror="this.onerror=null;this.src='{{ asset('website/images/logo/default.png') }}';">
                                <div class="icon">
                                    <i class="fas fa-search-plus"></i>
                                </div>
                                <div class="text">
                                    <p>{{ $item?->name }}</p>
                                </div>
                                <div class="background"></div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        @else
            @component('website::components.empty', [
                'title' => __('Empty Data'),
                'message' => __('No Data in this Album'),
                'image' => asset('images/empty.svg'),
                'style' => 'height: 300px; width: auto;',
            ])
            @endcomponent
        @endif
    </div>
@stop
