@extends('shared.layout')
@section('content')
    <!-- Video Album -->
    <div class="training-section container">
        <div class="border-wrapper">
            <div class="border" style="border-bottom: 1px solid yellow"></div>
            <h3 class="text-3xl text-yellow-500 uppercase">
                {{ $video_details['album']?->name }}
            </h3>
            <div class="border" style="border-bottom: 1px solid yellow"></div>
        </div>
        @if (isset($video_details['videos']) && count($video_details['videos']) > 0)
            <div class="training-section-container grid grid-cols-3 gap-x-5 gap-y-16 mt-10" x-data="video">
                @foreach ($video_details['videos'] as $item)
                    <div class="training-section-container-items ">
                        <div class="background">
                            <div class="background-img">
                                <div class="border"></div>
                                <div class="background-style">
                                </div>
                                <div class="item-img">
                                    <img width="100%" src="{{ asset('file_manager' . $item?->cover) }}" alt=""
                                        onerror="this.onerror=null;this.src='{{ asset('website/images/logo/default.png') }}';">
                                    <button class="gallery-btn"
                                        @click="openVideoDialog('{{ previewVideo($item?->video) }}')">
                                        <i class="fa-solid fa-play"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div class="quantity">
                            <p class="text-white uppercase">
                                {{ $item?->name }}
                            </p>
                        </div>
                    </div>
                @endforeach
                
                @include('website::components.video')
            </div>
        @else
            @component('website::components.empty', [
                'title' => __('Empty Data'),
                'message' => __('No Data in this Album'),
                'image' => asset('images/empty.svg'),
                'style' => 'height: 300px; width: auto;',
            ])
            @endcomponent
        @endif
    </div>

    <!-- Video Album -->
    @if (isset($related) && count($related) > 0)
        <div class="container">
            <div class="video-albums ">
                <div class="related-video">
                    <h3 class="text-2xl text-white text-left">Related Video</h3>
                    <hr>
                </div>
                <div class="video-albums-container mt-10">
                    @foreach ($related as $item)
                        <div class="video-albums-container-items" data-aos="fade-up" data-aos-duration="1000">
                            <div class="background">
                                <div class="background-img">
                                    <div class="border"></div>
                                    <div class="background-style">
                                        <div class="video-play-background">123</div>
                                        <div class="view-more">
                                            <a href="{{ route('website-gallery-index-video', $item?->id) }}">
                                                View video
                                            </a>
                                        </div>
                                    </div>

                                    <div class="item-img">
                                        <img src="{{ asset('file_manager' . $item?->cover) }}" alt=""
                                            onerror="this.onerror=null;this.src='{{ asset('website/images/logo/default.png') }}';">
                                        <div class="title-video-play">
                                            <h4 class="uppercase">{{ $item?->name }}</h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="quantity">
                                <p class="text-white">{{ $item->countVideo() }} Video(s)</p>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    @endif
@stop

@section('script')
    <script>
        Alpine.data("video", () => ({
            openVideoDialog(data) {
                this.$store.videoDialog.open({
                    data: {
                        data: data
                    }
                })
            }
        }));
    </script>
@stop
