@extends('shared.layout')
@section('content')
    <section class="gap-section">
        @if (isset($training_videos) && count($training_videos) > 0)
            <div class="training-section container" x-data="video">
                <div class="imgfix">
                    <img src="{{ asset('website/images/imgfix.jpg') }}" alt="">
                </div>
                @foreach ($training_videos as $item)
                    @if (optional($item?->videos) && count($item?->videos) > 0)
                        <div class="border-wrapper">
                            <div class="border" style="border-bottom: 1px solid yellow"></div>
                            <h3 class="text-3xl text-yellow-500 uppercase text-center">
                                {{ $item?->name }}
                            </h3>
                            <div class="border" style="border-bottom: 1px solid yellow"></div>
                        </div>
                        <div class="training-section-container grid grid-cols-3 gap-x-5 gap-y-16 ">
                            @foreach ($item?->videos as $video)
                                <div class="training-section-container-items">
                                    <div class="background">
                                        <div class="background-img">
                                            <div class="border"></div>
                                            <div class="background-style"></div>
                                            <div class="item-img">
                                                <img width="100%" src="{{ asset('file_manager' . $video?->cover) }}"
                                                    alt=""
                                                    onerror="this.onerror=null;this.src='{{ asset('website/images/logo/default.png') }}';">
                                                <a class="gallery-btn"
                                                    @if (auth('web')->check() && auth('web')->user()->role == 'user' && isset($user)) @click="openVideoDialog('{{ previewVideo($video?->video) }}')"
                                                        @else 
                                                        href="{{ route('website-auth-sign-in', ['returnUrl' => request()->url()]) }}" @endif>
                                                    <i class="fa-solid fa-play"></i>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="quantity">
                                        <p class="text-white uppercase">
                                            {{ $video?->name }}
                                        </p>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @endif
                @endforeach

                @include('website::components.video')
            </div>
        @else
            @component('website::components.empty', [
                'title' => __('Empty Data'),
                'message' => __('No Data in this Page'),
                'image' => asset('images/empty.svg'),
                'style' => 'height: 300px; width: auto;',
            ])
            @endcomponent
        @endif
    </section>
@stop
@section('script')
    <script>
        Alpine.data("video", () => ({
            openVideoDialog(data) {
                this.$store.videoDialog.open({
                    data: {
                        data: data
                    }
                })
            }
        }));
    </script>
@stop
