<?php

use App\Services\FileManager;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Artisan;
use App\Http\Controllers\Admin as Admin;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('clear-cache', function () {
    Artisan::call('optimize:clear');
    return "Cache is cleared";
});

Route::get('migration', function () {
    Artisan::call('migrate --path=database/migrations/2024_02_12_093407_alter_add_column_to_students_table.php'); 
    return "Migration Succeed";
});

Route::get('rollback', function () {
    Artisan::call('migrate:rollback'); 
    return "Rollback Succeed";
});

Route::get('db:seed-permissionSeeder', function () {
    Artisan::call('db:seed --class=PermissionSeeder');
    return "Permission Seed Succeed";
});
// Authentication
Route::prefix('auth')->group(function () {
    Route::get('/', function () {
        return redirect()->route('admin-login');
    });
    Route::get('/login', [Admin\UserController::class, 'login'])->name('login');
    Route::get('/forgot', [Admin\UserController::class, 'forgotPassword'])->name('forgot-password');
    Route::post('/login/post', [Admin\AuthController::class, 'login'])->name('login-post');
    Route::get('/sign-out', [Admin\AuthController::class, 'signOut'])->name('sign-out');
});

Route::middleware(['AdminGuard'])->group(function () {
    //File Manager
    Route::prefix('file-manager')->name('file-manager-')->group(function () {
        Route::get('/index', [FileManager::class, 'index'])->name('index');
        Route::get('/first', [FileManager::class, 'first'])->name('first');
        Route::get('/files', [FileManager::class, 'getFiles'])->name('files');
        Route::get('/folders', [FileManager::class, 'getFolders'])->name('folders');
        Route::post('/upload', [FileManager::class, 'uploadFile'])->name('upload');
        Route::post('/rename-file', [FileManager::class, 'renameFile'])->name('rename-file');
        Route::delete('/delete-file', [FileManager::class, 'deleteFile'])->name('delete-file');
        //folder
        Route::post('/create-folder', [FileManager::class, 'createFolder'])->name('create-folder');
        Route::post('/rename-folder', [FileManager::class, 'renameFolder'])->name('rename-folder');
        Route::delete('/delete-folder', [FileManager::class, 'deleteFolder'])->name('delete-folder');
        //trash bin
        Route::delete('/delete-all', [FileManager::class, 'deleteAll'])->name('delete-all');
        Route::put('/restore-all', [FileManager::class, 'restoreAll'])->name('restore-all');
    });

    Route::get('/', function () {
        return redirect()->route('admin-student-list');
    });
    Route::get('/dashboard', [Admin\DashboardController::class, 'index'])->name('dashboard');
    // User
    Route::prefix('user')->name('user-')->group(function () {
        Route::get('list/{id?}', [Admin\UserController::class, 'index'])->name('list');
        Route::get('create/{id?}', [Admin\UserController::class, 'onCreate'])->name('create');
        Route::post('save/{id?}', [Admin\UserController::class, 'onSave'])->name('save');
        Route::match(['get', 'post'], 'status/{id}/{status}', [Admin\UserController::class, 'onUpdateStatus'])->name('status');
        Route::get('change-password/{id}', [Admin\UserController::class, 'onChangePassword'])->name('change-password');
        Route::post('save-password/{id}', [Admin\UserController::class, 'onSavePassword'])->name('save-password');
        Route::get('permission/{id}', [Admin\UserController::class, 'setPermission'])->name('permission');
        Route::post('save-permission/{id}', [Admin\UserController::class, 'savePermission'])->name('save-permission');
    });

    // Class Type
    Route::prefix('class-type')->name('class-type-')->group(function () {
        Route::get('list/{id?}', [Admin\ClassTypeController::class, 'index'])->name('list');
        Route::get('create/{id?}', [Admin\ClassTypeController::class, 'onCreate'])->name('create');
        Route::post('save/{id?}', [Admin\ClassTypeController::class, 'onSave'])->name('save');
        Route::match(['get', 'post'], 'status/{id}/{status}', [Admin\ClassTypeController::class, 'onUpdateStatus'])->name('status');
    });

    // Class Status
    Route::prefix('class-status')->name('class-status-')->group(function () {
        Route::get('list/{id?}', [Admin\ClassStatusController::class, 'index'])->name('list');
        Route::get('create/{id?}', [Admin\ClassStatusController::class, 'onCreate'])->name('create');
        Route::post('save/{id?}', [Admin\ClassStatusController::class, 'onSave'])->name('save');
        Route::match(['get', 'post'], 'status/{id}/{status}', [Admin\ClassStatusController::class, 'onUpdateStatus'])->name('status');
    });

    // Class Level
    Route::prefix('class-level')->name('class-level-')->group(function () {
        Route::get('list/{id?}', [Admin\ClassLevelController::class, 'index'])->name('list');
        Route::get('create/{id?}', [Admin\ClassLevelController::class, 'onCreate'])->name('create');
        Route::post('save/{id?}', [Admin\ClassLevelController::class, 'onSave'])->name('save');
        Route::match(['get', 'post'], 'status/{id}/{status}', [Admin\ClassLevelController::class, 'onUpdateStatus'])->name('status');
    });

    // Class
    Route::prefix('class')->name('class-')->group(function () {
        Route::get('list/{id?}', [Admin\ClassController::class, 'index'])->name('list');
        Route::get('create/{id?}', [Admin\ClassController::class, 'onCreate'])->name('create');
        Route::post('save/{id?}', [Admin\ClassController::class, 'onSave'])->name('save');
        Route::match(['get', 'post'], 'status/{id}/{status}', [Admin\ClassController::class, 'onUpdateStatus'])->name('status');
        Route::get('view-info/{id}', [Admin\ClassController::class, 'onView'])->name('view-info');
        Route::get('assign-structured/{id}', [Admin\ClassController::class, 'onAssignStructured'])->name('assign-structured');
        Route::post('assign-structured/{id}', [Admin\ClassController::class, 'onSaveAssignStructured'])->name('save-assign-structured');
        Route::get('study-material/{class_id}', [Admin\ClassController::class, 'studyMaterial'])->name('study-material');
        Route::get('student-card/{class_id}', [Admin\ClassController::class, 'studentCard'])->name('student-card');
        Route::get('student-certificate/{class_id}', [Admin\ClassController::class, 'studentCertificate'])->name('student-certificate');
        Route::match(['get', 'post'], 'remove-student/{student_id}/{class_id}', [Admin\ClassController::class, 'onRemoveStudent'])->name('remove-student');

        Route::get('allow-user/{id?}', [Admin\ClassController::class, 'onAllowUser'])->name('allow-user');
        Route::post('save-allow-user/{id?}', [Admin\ClassController::class, 'onSaveAllowUser'])->name('save-allow-user');
    });

    // Shift
    Route::prefix('shift')->name('shift-')->group(function () {
        Route::get('list/{id?}', [Admin\ShiftController::class, 'index'])->name('list');
        Route::get('create/{id?}', [Admin\ShiftController::class, 'onCreate'])->name('create');
        Route::post('save/{id?}', [Admin\ShiftController::class, 'onSave'])->name('save');
        Route::match(['get', 'post'], 'status/{id}/{status}', [Admin\ShiftController::class, 'onUpdateStatus'])->name('status');
    });

    // Education
    Route::prefix('education')->name('education-')->group(function () {
        Route::get('list/{id?}', [Admin\EducationController::class, 'index'])->name('list');
        Route::get('create/{id?}', [Admin\EducationController::class, 'onCreate'])->name('create');
        Route::post('save/{id?}', [Admin\EducationController::class, 'onSave'])->name('save');
        Route::match(['get', 'post'], 'status/{id}/{status}', [Admin\EducationController::class, 'onUpdateStatus'])->name('status');
    });
    // Occupation
    Route::prefix('occupation')->name('occupation-')->group(function () {
        Route::get('list/{id?}', [Admin\OccupationController::class, 'index'])->name('list');
        Route::get('create/{id?}', [Admin\OccupationController::class, 'onCreate'])->name('create');
        Route::post('save/{id?}', [Admin\OccupationController::class, 'onSave'])->name('save');
        Route::match(['get', 'post'], 'status/{id}/{status}', [Admin\OccupationController::class, 'onUpdateStatus'])->name('status');
    });

    // Class Occupation
    Route::prefix('class-occupation')->name('class-occupation-')->group(function () {
        Route::get('list/{id?}', [Admin\ClassOccupationController::class, 'index'])->name('list');
        Route::get('create/{id?}', [Admin\ClassOccupationController::class, 'onCreate'])->name('create');
        Route::post('save/{id?}', [Admin\ClassOccupationController::class, 'onSave'])->name('save');
        Route::match(['get', 'post'], 'status/{id}/{status}', [Admin\ClassOccupationController::class, 'onUpdateStatus'])->name('status');
    });

    // Internship Place
    Route::prefix('internship-place')->name('internship-place-')->group(function () {
        Route::get('list/{id?}', [Admin\InternshipPlaceController::class, 'index'])->name('list');
        Route::get('create/{id?}', [Admin\InternshipPlaceController::class, 'onCreate'])->name('create');
        Route::post('save/{id?}', [Admin\InternshipPlaceController::class, 'onSave'])->name('save');
        Route::match(['get', 'post'], 'status/{id}/{status}', [Admin\InternshipPlaceController::class, 'onUpdateStatus'])->name('status');
    });

    // Exam Type
    Route::prefix('exam-type')->name('exam-type-')->group(function () {
        Route::get('list/{id?}', [Admin\ExamTypeController::class, 'index'])->name('list');
        Route::get('create/{id?}', [Admin\ExamTypeController::class, 'onCreate'])->name('create');
        Route::post('save/{id?}', [Admin\ExamTypeController::class, 'onSave'])->name('save');
        Route::match(['get', 'post'], 'status/{id}/{status}', [Admin\ExamTypeController::class, 'onUpdateStatus'])->name('status');
    });

    // Student
    Route::prefix('student')->name('student-')->group(function () {
        Route::get('list/{id?}', [Admin\StudentController::class, 'index'])->name('list');
        Route::get('create/{id?}', [Admin\StudentController::class, 'onCreate'])->name('create');
        Route::post('save/{id?}', [Admin\StudentController::class, 'onSave'])->name('save');
        Route::match(['get', 'post'], 'status/{id}/{status}', [Admin\StudentController::class, 'onUpdateStatus'])->name('status');
        Route::match(['get', 'post'], 'approval-status/{id}/{approval_status}', [Admin\StudentController::class, 'onUpdateRequestApprovalStatus'])->name('approval-status');
        Route::get('assign-class/{id}', [Admin\StudentController::class, 'onAssignClass'])->name('assign-class');
        Route::post('assign-class/{id}', [Admin\StudentController::class, 'onSaveAssignClass'])->name('save-assign-class');
        Route::get('view/{id}', [Admin\StudentController::class, 'onView'])->name('view');
        Route::get('export-excel', [Admin\StudentController::class, 'exportExcel'])->name('export-excel');
    });


    // Page
    // Route::prefix('page')->name('page-')->group(function() {
    //     Route::get('/{type?}', [Admin\PageController::class, 'page'])->name('page');
    //     Route::post('save/{id?}', [Admin\PageController::class, 'onSave'])->name('save');
    // });
    //contact
    // Route::prefix('contact')->name('contact-')->group(function() {
    //     Route::get('/{type?}', [Admin\ContactController::class, 'index'])->name('contact');
    //     Route::post('save/{id?}', [Admin\ContactController::class, 'store'])->name('save');
    // });

    // Staff Type
    Route::prefix('staff-type')->name('staff-type-')->group(function () {
        Route::get('list/{id?}', [Admin\StaffTypeController::class, 'index'])->name('list');
        Route::get('create/{id?}', [Admin\StaffTypeController::class, 'onCreate'])->name('create');
        Route::post('save/{id?}', [Admin\StaffTypeController::class, 'onSave'])->name('save');
        Route::match(['get', 'post'], 'status/{id}/{status}', [Admin\StaffTypeController::class, 'onUpdateStatus'])->name('status');
    });
    // Lesson
    Route::prefix('lesson')->name('lesson-')->group(function () {
        Route::get('list/{id?}', [Admin\LessonController::class, 'index'])->name('list');
        Route::get('create/{id?}', [Admin\LessonController::class, 'onCreate'])->name('create');
        Route::post('save/{id?}', [Admin\LessonController::class, 'onSave'])->name('save');
        Route::match(['get', 'post'], 'status/{id}/{status}', [Admin\LessonController::class, 'onUpdateStatus'])->name('status');
    });
    // Student
    Route::prefix('staff')->name('staff-')->group(function () {
        Route::get('list/{id?}', [Admin\StaffController::class, 'index'])->name('list');
        Route::get('create/{id?}', [Admin\StaffController::class, 'onCreate'])->name('create');
        Route::post('save/{id?}', [Admin\StaffController::class, 'onSave'])->name('save');
        Route::match(['get', 'post'], 'status/{id}/{status}', [Admin\StaffController::class, 'onUpdateStatus'])->name('status');
    });

    // Class Program
    Route::prefix('program-class')->name('program-class-')->group(function () {
        Route::get('list/{id?}', [Admin\ProgramClassController::class, 'index'])->name('list');
        Route::get('create/{id?}', [Admin\ProgramClassController::class, 'onCreate'])->name('create');
        Route::post('save/{id?}', [Admin\ProgramClassController::class, 'onSave'])->name('save');
    });

    // Study Score
    Route::prefix('study-score')->name('study-score-')->group(function () {
        Route::get('list/{id?}', [Admin\StudyScoreController::class, 'index'])->name('list');
        Route::get('create/{id?}', [Admin\StudyScoreController::class, 'onCreate'])->name('create');
        Route::post('save/{id?}', [Admin\StudyScoreController::class, 'onSave'])->name('save');
        Route::match(['get', 'post'], 'status/{id}/{status}', [Admin\StudyScoreController::class, 'onUpdateStatus'])->name('status');
    });
    // Structure Program
    Route::prefix('structure-program')->name('structure-program-')->group(function () {
        Route::get('list/{id?}', [Admin\StructureProgramController::class, 'index'])->name('list');
        Route::get('create/{id?}', [Admin\StructureProgramController::class, 'onCreate'])->name('create');
        Route::post('save/{id?}', [Admin\StructureProgramController::class, 'onSave'])->name('save');
        Route::get('assign-class/{id}', [Admin\StructureProgramController::class, 'onAssignClass'])->name('assign-class');
        Route::post('assign-class/{id}', [Admin\StructureProgramController::class, 'onSaveAssignClass'])->name('save-assign-class');
        Route::get('remove-from-class', [Admin\StructureProgramController::class, 'onRemoveClass'])->name('remove-from-class');
        Route::get('delete/{id}', [Admin\StructureProgramController::class, 'onDelete'])->name('delete');
        Route::get('lesson', [Admin\StructureProgramController::class, 'lesson'])->name('lesson');
    });
    // Attendance
    Route::prefix('attendance')->name('attendance-')->group(function () {
        Route::get('list/{id?}', [Admin\AttendanceController::class, 'index'])->name('list');
        Route::get('create/{class_id?}', [Admin\AttendanceController::class, 'onCreate'])->name('create');
        Route::post('save/{id?}', [Admin\AttendanceController::class, 'onSave'])->name('save');
        Route::post('update-student-attendance', [Admin\AttendanceController::class, 'onUpdateStudentAttendance'])->name('update-student-attendance');
        Route::post('delete-student-attendance', [Admin\AttendanceController::class, 'onDeleteStudentAttendance'])->name('delete-student-attendance');
        Route::get('delete/{id}', [Admin\AttendanceController::class, 'onDeleteAttendance'])->name('delete');
    });

    // listing
    Route::prefix('listing')->name('listing-')->group(function () {
        Route::get('student', [Admin\SelectController::class, 'viewStudent'])->name('student');
        Route::get('attendances', [Admin\SelectController::class, 'attendance'])->name('attendances');
        Route::get('class', [Admin\SelectController::class, 'viewClass'])->name('class');
        Route::get('student-attendance-amount', [Admin\SelectController::class, 'studentAttendanceAmount'])->name('student-attendance-amount');
        Route::get('student-in-class', [Admin\SelectController::class, 'studentInClass'])->name('student-in-class');
    });

    // printing
    Route::prefix('printing')->name('printing-')->group(function () {
        Route::get('student/{id}', [Admin\PrintingController::class, 'student'])->name('student');
        Route::get('student/{id}/{about}', [Admin\PrintingController::class, 'student'])->name('student');
        Route::get('attendance/{id}', [Admin\PrintingController::class, 'attendance'])->name('attendance');
        Route::get('attendance-date/{id}/{date?}', [Admin\PrintingController::class, 'attendanceDate'])->name('attendance-date');
        Route::get('student-score/{class_id}', [Admin\PrintingController::class, 'studentScore'])->name('student-score');
        Route::get('exam-candidate/{class_id}/{exam_id}', [Admin\PrintingController::class, 'examCandidate'])->name('exam-candidate');
        Route::get('student-group/{class_id}', [Admin\PrintingController::class, 'studentGroup'])->name('student-group');
    });
    // Assign Internship Place to Student
    Route::prefix('assign-internship-place')->name('assign-internship-place-')->group(function () {
        Route::post('assign', [Admin\StudentInternPlaceController::class, 'assign'])->name('assign');
        Route::post('unassign/{student_id}/{class_id}/{start_date}', [Admin\StudentInternPlaceController::class, 'unassign'])->name('unassign');
        Route::get('listing/{class_id}', [Admin\StudentInternPlaceController::class, 'index'])->name('listing');
        Route::match(['get', 'post'], 'status/{id}/{status}', [Admin\StudentInternPlaceController::class, 'onUpdateStatus'])->name('status');
    });
    // Staff Position 
    Route::prefix('staff-position')->name('staff-position-')->group(function () {
        Route::get('list/{id?}', [Admin\StaffPositionController::class, 'index'])->name('list');
        Route::get('create/{id?}', [Admin\StaffPositionController::class, 'onCreate'])->name('create');
        Route::post('save/{id?}', [Admin\StaffPositionController::class, 'onSave'])->name('save');
        Route::match(['get', 'post'], 'status/{id}/{status}', [Admin\StaffPositionController::class, 'onUpdateStatus'])->name('status');
    });
    // group
    Route::prefix('group')->name('group-')->group(function () {
        Route::get('list/{class_id}', [Admin\GroupController::class, 'index'])->name('list');
        Route::post('save/{class_id}', [Admin\GroupController::class, 'onSave'])->name('save');
        Route::get('delete/{group_id}', [Admin\GroupController::class, 'onDelete'])->name('delete');
        Route::post('assign', [Admin\GroupController::class, 'onAssign'])->name('assign');
        Route::post('unassign', [Admin\GroupController::class, 'onUnassign'])->name('unassign');
        Route::get('student', [Admin\GroupController::class, 'studentCondition'])->name('student');
        Route::get('students', [Admin\GroupController::class, 'studentInGroup'])->name('students');
    });

    // study note
    Route::prefix('study-note')->name('study-note-')->group(function () {
        Route::post('save', [Admin\StudyNoteController::class, 'onSave'])->name('save');
        Route::get('delete', [Admin\StudyNoteController::class, 'onDelete'])->name('delete');
        Route::get('student', [Admin\StudyNoteController::class, 'student'])->name('student');
    });
    // exam contorl
    Route::prefix('exam-control')->name('exam-control-')->group(function () {
        Route::get('list/{class_id}', [Admin\ExamController::class, 'index'])->name('list');
        Route::post('save', [Admin\ExamController::class, 'onSave'])->name('save');
        Route::get('show', [Admin\ExamController::class, 'onView'])->name('show');
        Route::get('delete/{id}', [Admin\ExamController::class, 'onDelete'])->name('delete');
        // Route::get('add-answer-sheet', [Admin\ExamController::class, 'onAddAnswerSheet'])->name('add-answer-sheet');
        Route::get('exam-score-table', [Admin\ExamController::class, 'onExamScoreTable'])->name('exam-score-table');
        Route::get('enter-student-score/{class_id}', [Admin\ExamController::class, 'onEnterStudentScore'])->name('enter-student-score');
    });
    // exam score
    Route::prefix('exam-score')->name('exam-score-')->group(function () {
        Route::post('save/{class_id}', [Admin\ExamScoreController::class, 'onSave'])->name('save');
    });


    // exam subject
    Route::prefix('exam-subject')->name('exam-subject-')->group(function () {
        Route::get('list', [Admin\ExamSubjectController::class, 'index'])->name('list');
        Route::post('save', [Admin\ExamSubjectController::class, 'onSave'])->name('save');
        Route::get('show', [Admin\ExamSubjectController::class, 'onView'])->name('show');
        Route::post('delete', [Admin\ExamSubjectController::class, 'onDelete'])->name('delete');
        // Route::get('delete/{id}', [Admin\ExamSubjectController::class, 'onDelete'])->name('delete');
    });

    // exam candidate
    Route::prefix('exam-candidate')->name('exam-candidate-')->group(function () {
        Route::post('assign', [Admin\ExamCandidateController::class, 'onAssign'])->name('assign');
        Route::post('unassign', [Admin\ExamCandidateController::class, 'onUnassign'])->name('unassign');
        Route::get('list', [Admin\ExamCandidateController::class, 'index'])->name('list');
    });

    // exam answer sheet
    Route::prefix('exam-answer-sheet')->name('exam-answer-sheet-')->group(function () {
        Route::get('list', [Admin\ExamAnswerSheetController::class, 'index'])->name('list');
        Route::post('save', [Admin\ExamAnswerSheetController::class, 'onSave'])->name('save');
        Route::get('on-exam-subject', [Admin\ExamAnswerSheetController::class, 'onExamSubject'])->name('on-exam-subject');
        Route::post('delete', [Admin\ExamAnswerSheetController::class, 'onDelete'])->name('delete');
    });

    // exam subject
    Route::prefix('student-lesson-score')->name('student-lesson-score-')->group(function () {
        Route::post('save/{class_id}', [Admin\StudentLessonScoreController::class, 'onSave'])->name('save');
    });

    // class image
    Route::prefix('class-image')->name('class-image-')->group(function () {
        Route::get('list/{class_id}', [Admin\ClassImageController::class, 'index'])->name('list');
        Route::get('create/{class_id}', [Admin\ClassImageController::class, 'onCreate'])->name('create');
        Route::post('save/{class_id}', [Admin\ClassImageController::class, 'onSave'])->name('save');
        Route::get('delete/{id}', [Admin\ClassImageController::class, 'onDelete'])->name('delete');
    });
    Route::prefix('teacher-portal')->name('teacher-portal-')->group(function () {
        Route::get('/', function () {
            return redirect()->route('admin-teacher-portal-list');
        });
        Route::get('list', [Admin\TeacherPortalController::class, 'index'])->name('list');
        Route::get('create/{class_id}/{id?}', [Admin\TeacherPortalController::class, 'oninsertAttendance'])->name('create');
        Route::post('save/{id?}', [Admin\TeacherPortalController::class, 'onSaveAttendance'])->name('save');
        Route::get('attend/{class_id}', [Admin\TeacherPortalController::class, 'todayAttend'])->name('attend');

        Route::get('student/{class_id}', [Admin\TeacherPortalController::class, 'studentList'])->name('student');
        Route::get('class-attendance/{class_id}', [Admin\TeacherPortalController::class, 'classAttendance'])->name('class-attendance');
        Route::get('group/{class_id}', [Admin\TeacherPortalController::class, 'groupList'])->name('group');
        Route::get('additional-info/{class_id}', [Admin\TeacherPortalController::class, 'additionalInfo'])->name('additional-info');
        Route::get('exam/{class_id}', [Admin\TeacherPortalController::class, 'exam'])->name('exam');

        // json
        Route::get('get-exam-subject', [Admin\TeacherPortalController::class, 'examSubject'])->name('get-exam-subject');
        Route::get('get-exam-candidate', [Admin\TeacherPortalController::class, 'examCandidate'])->name('get-exam-candidate');
        Route::post('exam-answer-sheet', [Admin\TeacherPortalController::class, 'onExamAnswerSheet'])->name('exam-answer-sheet');
        Route::get('get-exam-answer-sheet', [Admin\TeacherPortalController::class, 'examAnswerSheet'])->name('get-exam-answer-sheet');
        Route::get('get-student-score', [Admin\TeacherPortalController::class, 'studentScore'])->name('get-student-score');
    });

    // setting
    Route::prefix('contact')->name('contact-')->group(function () {
        Route::get('create', [Admin\ContactController::class, 'onCreate'])->name('create');
        Route::post('save', [Admin\ContactController::class, 'onSave'])->name('save');
        Route::get('cover/create', [Admin\ContactController::class, 'onCreateCover'])->name('cover-create');
    });

    Route::prefix('about')->name('about-')->group(function () {
        Route::get('create', [Admin\AboutController::class, 'onCreate'])->name('create');
        Route::post('save', [Admin\AboutController::class, 'onSave'])->name('save');

        Route::get('cover/create', [Admin\AboutController::class, 'onCreateCover'])->name('cover-create');

        Route::prefix('child')->name('child-')->group(function () {
            Route::get('list/{id}', [Admin\AboutChildCotroller::class, 'index'])->name('list');
            Route::get('create/{id?}', [Admin\AboutChildCotroller::class, 'onCreate'])->name('create');
            Route::post('save/{id?}', [Admin\AboutChildCotroller::class, 'onSave'])->name('save');
            Route::match(['get', 'post'], 'status/{id}/{status}', [Admin\AboutChildCotroller::class, 'onUpdateStatus'])->name('status');
        });
    });

    Route::prefix('cover')->name('cover-')->group(function () {
        Route::post('save', [Admin\CoverController::class, 'onSave'])->name('save');
    });

    Route::prefix('trainer')->name('trainer-')->group(function () {
        Route::get('list/{id}', [Admin\TrainerController::class, 'index'])->name('list');
        Route::get('create/{id?}', [Admin\TrainerController::class, 'onCreate'])->name('create');
        Route::post('save/{id?}', [Admin\TrainerController::class, 'onSave'])->name('save');
        Route::match(['get', 'post'], 'status/{id}/{status}', [Admin\TrainerController::class, 'onUpdateStatus'])->name('status');
    });

    Route::prefix('course')->name('course-')->group(function () {
        Route::get('list/{id}', [Admin\CourseController::class, 'index'])->name('list');
        Route::get('create/{id?}', [Admin\CourseController::class, 'onCreate'])->name('create');
        Route::post('save/{id?}', [Admin\CourseController::class, 'onSave'])->name('save');
        Route::match(['get', 'post'], 'status/{id}/{status}', [Admin\CourseController::class, 'onUpdateStatus'])->name('status');
        Route::get('slide/list/{id}', [Admin\CourseController::class, 'slide'])->name('slide-list');
        Route::get('slide/create/{id?}', [Admin\CourseController::class, 'onCreateSlide'])->name('slide-create');
    });

    Route::prefix('partner')->name('partner-')->group(function () {
        Route::get('list/{id}', [Admin\PartnerController::class, 'index'])->name('list');
        Route::get('create/{id?}', [Admin\PartnerController::class, 'onCreate'])->name('create');
        Route::post('save/{id?}', [Admin\PartnerController::class, 'onSave'])->name('save');
        Route::match(['get', 'post'], 'status/{id}/{status}', [Admin\PartnerController::class, 'onUpdateStatus'])->name('status');
        Route::get('slide/list/{id}', [Admin\PartnerController::class, 'slide'])->name('slide-list');
        Route::get('slide/create/{id?}', [Admin\PartnerController::class, 'onCreateSlide'])->name('slide-create');
    });

    Route::prefix('question')->name('question-')->group(function () {
        Route::get('list/{id}', [Admin\QuestionController::class, 'index'])->name('list');
        Route::get('create/{id?}', [Admin\QuestionController::class, 'onCreate'])->name('create');
        Route::post('save/{id?}', [Admin\QuestionController::class, 'onSave'])->name('save');
        Route::match(['get', 'post'], 'status/{id}/{status}', [Admin\QuestionController::class, 'onUpdateStatus'])->name('status');
    });

    Route::prefix('gallery')->name('gallery-')->group(function () {
        Route::get('list/{id}', [Admin\GalleryController::class, 'index'])->name('list');
        Route::get('create/{id?}', [Admin\GalleryController::class, 'onCreate'])->name('create');
        Route::post('save/{id?}', [Admin\GalleryController::class, 'onSave'])->name('save');
        Route::match(['get', 'post'], 'status/{id}/{status}', [Admin\GalleryController::class, 'onUpdateStatus'])->name('status');
    });

    Route::prefix('video')->name('video-')->group(function () {
        Route::get('list/{id}', [Admin\VideoController::class, 'index'])->name('list');
        Route::get('create/{id?}', [Admin\VideoController::class, 'onCreate'])->name('create');
        Route::post('save/{id?}', [Admin\VideoController::class, 'onSave'])->name('save');
        Route::match(['get', 'post'], 'status/{id}/{status}', [Admin\VideoController::class, 'onUpdateStatus'])->name('status');
    });

    Route::prefix('work-day')->name('work-day-')->group(function () {
        Route::get('list/{id}', [Admin\WorkDayController::class, 'index'])->name('list');
        Route::get('create/{id?}', [Admin\WorkDayController::class, 'onCreate'])->name('create');
        Route::post('save/{id?}', [Admin\WorkDayController::class, 'onSave'])->name('save');
        Route::match(['get', 'post'], 'status/{id}/{status}', [Admin\WorkDayController::class, 'onUpdateStatus'])->name('status');
    });
    Route::prefix('album')->name('album-')->group(function () {
        Route::get('list/{id}', [Admin\AlbumController::class, 'index'])->name('list');
        Route::get('create/{id?}', [Admin\AlbumController::class, 'onCreate'])->name('create');
        Route::post('save/{id?}', [Admin\AlbumController::class, 'onSave'])->name('save');
        Route::match(['get', 'post'], 'status/{id}/{status}', [Admin\AlbumController::class, 'onUpdateStatus'])->name('status');
    });

    Route::prefix('slide')->name('slide-')->group(function () {
        Route::get('list/{id}', [Admin\SlideController::class, 'index'])->name('list');
        Route::get('create/{id?}', [Admin\SlideController::class, 'onCreate'])->name('create');
        Route::post('save/{id?}', [Admin\SlideController::class, 'onSave'])->name('save');
        Route::match(['get', 'post'], 'status/{id}/{status}', [Admin\SlideController::class, 'onUpdateStatus'])->name('status');
    });

    Route::prefix('qoute')->name('qoute-')->group(function () {
        Route::get('list/{id}', [Admin\QouteController::class, 'index'])->name('list');
        Route::get('create/{id?}', [Admin\QouteController::class, 'onCreate'])->name('create');
        Route::post('save/{id?}', [Admin\QouteController::class, 'onSave'])->name('save');
        Route::match(['get', 'post'], 'status/{id}/{status}', [Admin\QouteController::class, 'onUpdateStatus'])->name('status');
    });

    Route::prefix('category')->name('category-')->group(function () {
        Route::get('list/{id}', [Admin\TrainingVideoCategoryController::class, 'index'])->name('list');
        Route::get('create/{id?}', [Admin\TrainingVideoCategoryController::class, 'onCreate'])->name('create');
        Route::post('save/{id?}', [Admin\TrainingVideoCategoryController::class, 'onSave'])->name('save');
        Route::match(['get', 'post'], 'status/{id}/{status}', [Admin\TrainingVideoCategoryController::class, 'onUpdateStatus'])->name('status');
    });

    Route::prefix('training-video')->name('training-video-')->group(function () {
        Route::get('list/{id}', [Admin\TrainingVideoController::class, 'index'])->name('list');
        Route::get('create/{id?}', [Admin\TrainingVideoController::class, 'onCreate'])->name('create');
        Route::post('save/{id?}', [Admin\TrainingVideoController::class, 'onSave'])->name('save');
        Route::match(['get', 'post'], 'status/{id}/{status}', [Admin\TrainingVideoController::class, 'onUpdateStatus'])->name('status');
    });

    Route::prefix('user-feedback')->name('user-feedback-')->group(function () {
        Route::get('list/{id}', [Admin\UserFeedbackController::class, 'index'])->name('list');
        Route::get('detial/{id}', [Admin\UserFeedbackController::class, 'onShow'])->name('detail');
    });


    // Branch
    Route::prefix('branch')->name('branch-')->group(function () {
        // Route::get('list/{id}/{referent?}', [BranchController::class, 'index'])->where('referent', '(.*)')->name('list');
        Route::get('list/{id}/{referent?}', [Admin\BranchController::class, 'index'])->where('referent', '(.*)')->name('list');
        Route::get('create/{id?}', [Admin\BranchController::class, 'onCreate'])->name('create');
        Route::post('save/{id?}', [Admin\BranchController::class, 'onSave'])->name('save');
        Route::match(['get', 'post'], 'status/{id}/{status}', [Admin\BranchController::class, 'onUpdateStatus'])->name('status');
    });
});
