<?php

use App\Events\BookingEvent;
use App\Http\Controllers\Website\CourseController;
use App\Http\Controllers\Website\HomeController;
use App\Http\Controllers\Website\PageController;
use App\Http\Controllers\Website\GalleryController;
use App\Http\Controllers\Website\AuthController;
use App\Http\Controllers\Website\PartnerController;
use App\Http\Controllers\Website\TrainingController;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\View;

Route::name('website-')
    ->group(function () {
        Route::controller(HomeController::class)
            ->group(function () {
                Route::get('/', 'onHome')->name('home');
        });

        // Page
        Route::controller(PageController::class)
            ->prefix('page')
            ->name('page-')
            ->group(function () {
                Route::get('/about-us', 'onAboutUs')->name('about-us');
                Route::post('/get-in-touch', 'onGetInTouch')->name('get-in-touch');
        });

        // Partner
        Route::controller(PartnerController::class)
            ->prefix('partner')
            ->name('partner-')
            ->group(function () {
                Route::get('/', 'onIndex')->name('index');
                Route::get('/list', 'onPartner')->name('list');
        });

        // Course
        Route::controller(CourseController::class)
            ->prefix('course')
            ->name('course-')
            ->group(function () {
                Route::get('/', 'onIndex')->name('index');
                Route::get('/trainer', 'onTrainer')->name('trainer');
                Route::get('/search', 'onSearch')->name('search');
                Route::post('/register', 'onRegister')->name('register');
        });

        // Gallery
        Route::controller(GalleryController::class)
            ->prefix('gallery')
            ->name('gallery-')
            ->group(function () {
                Route::get('/', 'onIndex')->name('index');
                Route::get('/photo-list/{id?}', 'onPhoto')->name('index-photo');
                Route::get('/video-list/{id?}', 'onVideo')->name('index-video');
        });

        // Training
        Route::controller(TrainingController::class)
            ->prefix('training')
            ->name('training-')
            ->group(function () {
                Route::get('/', 'onIndex')->name('index');
        });

    });

    Route::controller(AuthController::class)
        ->prefix('auth')
        ->name('website-auth-')
        ->group(function () {
            Route::get('/sign-in', 'onSignIn')->name('sign-in');
            Route::post('/sign-in', 'onAccessSignIn')->name('access-sign-in');
            Route::post('/request/otp', 'onRequestOtp')->name('request-otp');
            Route::get('/sign-up', 'onSignUp')->name('sign-up');
            Route::post('/sign-up', 'onSignUpStore')->name('sign-up-store');
            Route::get('/forgot-password', 'onForgotPassword')->name('forgot-password');
            Route::post('/forgot-password', 'onResetPassword')->name('reset-password');
            Route::get('/sign-out', 'onSignOut')->name('sign-out');
            Route::post('/social','onSocial')->name('social');
        });


    Route::get('/pusher', function () {
        return view("admin::pusher");
    });