<?php $__env->startComponent('website::components.dialog', ['dialog' => 'registerDialog']); ?>
    <div class="pop-up" x-data="register">
        <div class="pop-up-wrapper">
            <div class="pop-up-close" @click="$store.registerDialog.close()">
                <i data-feather="x"></i>
            </div>
            <div class="pop-up-body">
                <div class="register-box">
                    <div class="auth-dialog go-dialog">
                        <div class="auth">
                            <div class="img">
                                <img x-bind:src="path + dataDialog?.image" alt="" onerror="this.onerror=null;this.src='<?php echo e(asset('website/images/logo/default.png')); ?>';">
                            </div>
                            <div class="switch-form">
                                <form action="<?php echo e(route('website-course-register')); ?>" method="post" x-form="submit">
                                    <div class="form login">
                                        <div class="auth-label mt-2">
                                            <span class="label-name">Register Form</span>
                                            <p x-text="'Register to Course : ' + dataDialog?.name"></p>
                                        </div>
                                        <div class="form-row">
                                            <div class="form-box">
                                                <i class="fa-solid fa-circle-user"></i>
                                                <input type="text" name="name"
                                                    value="<?php echo e(isset($user) ? $user?->username : ''); ?>"
                                                    placeholder="<?php echo e(isset($user) ? $user?->username : 'Full Name'); ?>">
                                            </div>
                                            <span class="text-red-600 text-xs" x-show="validate?.name"
                                                x-text="validate?.name"></span>
                                            </span>
                                        </div>
                                        <div class="form-row">
                                            <div class="form-box">
                                                <i class="fa-solid fa-phone"></i>
                                                <input type="text" name="phone"
                                                    value="<?php echo e(isset($user) ? $user?->phone : ''); ?>"
                                                    placeholder="<?php echo e(isset($user) ? $user?->phone : 'Phone'); ?>">
                                            </div>
                                            <span class="text-red-600 text-xs" x-show="validate?.phone"
                                                x-text="validate?.phone"></span>
                                            </span>
                                        </div>

                                        <input type="hidden" name="course_id" readonly x-bind:value="dataDialog?.id">
                                        <div class="btn-auth">
                                            <button type="submit" class="mat-flat-button mat-button-base">
                                                <span class="mat-button-wrapper">
                                                    Register Now
                                                </span>
                                                <div class="mat-button-ripple mat-ripple" matripple=""></div>
                                                <div class="mat-button-focus-overlay"></div>
                                            </button>
                                        </div>
                                        <div class="form-label">
                                            <span class="text-[14px]">Register via account? &nbsp;
                                                <a href="<?php echo e(route('website-auth-sign-up', ['returnUrl' => request()->url()])); ?>"
                                                    class="text-[14px] !underline !text-yellow-600">Create one</a>
                                            </span>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        Alpine.data('register', () => ({
            validate: null,
            loading: false,
            dataDialog: null,
            path: '<?php echo e(asset('file_manager')); ?>',

            init() {
                let data = this.$store.registerDialog.data;
                this.dataDialog = JSON.parse(data?.data);
            },

            submit(response) {
                this.loading = response.loading;
                this.validate = response.data.errors;
                var data = response.data;

                if (data.status == true && response.completed == true) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Course Register',
                        html: 'You have been registered to :' + this.dataDialog?.name,
                        showConfirmButton: false,
                        timer: 4000
                    }).then(() => {
                        this.$store.registerDialog.close();
                    });
                }

                if (data.status == false && response.completed == true) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        html: data.message,
                        showConfirmButton: false,
                        timer: 4000
                    });
                }

                this.loading = response.loading;
            },
        }));
    </script>
<?php echo $__env->renderComponent(); ?>
<?php /**PATH /home/1051036.cloudwaysapps.com/bffmptmecd/public_html/resources/website/views/components/register-dialog.blade.php ENDPATH**/ ?>