<div class="file-manager-wrapper" x-data="settingsPage" :class="{ 'full-page': $store.page.full_page }">
    <?php echo $__env->make('admin::file-manager.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="file-manager-body">
        <div class="breadcrumb">
            <span>
                <?php echo app('translator')->get('file-manager.breadcrumb.setting'); ?>
            </span>
        </div>
        <div class="file-side">
            <?php echo $__env->make('admin::file-manager.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="file-list">
                <?php $__env->startComponent('components.empty', [
                    'name' => 'Coming Soon...',
                    'image' => asset('images/logo/em.svg'),
                    'msg' => 'This feature is coming soon.',
                    'style' => 'padding: 50px 0;',
                ]); ?>
                <?php echo $__env->renderComponent(); ?>
            </div>
        </div>
    </div>
    <div class="file-manager-footer">
        <div class="file-manager-button">
            
        </div>
    </div>
    <script type="module">
        Alpine.data('settingsPage', () => ({
            init() {
                this.reloadIcon();
            },
            reloadIcon() {
                feather.replace();
                setTimeout(() => {
                    feather.replace();
                }, 10);
            },
            onClose() {
                Alpine.store('animate').leave(this.$refs.popupRef, (res) => {
                    Alpine.store('page').active = false;
                    Alpine.store('page').options.afterClose(false);
                });
            },
        }));
    </script>
</div>
<?php /**PATH /home/1051036.cloudwaysapps.com/bffmptmecd/public_html/resources/admin/views/file-manager/settings.blade.php ENDPATH**/ ?>