<template x-if="createStudyNote">
    <div class="classLogDialogLayout">
        <div class="classLogDialog">
            <div class="content-body d-flex flex-column overflow-auto h-100">
                <div class="bg-white mb-3">
                    <div id="student-list" class="form-body p-3" style="box-shadow: none">
                        <div>
                            <h2 class="mt-0">
                                Create Study Note
                            </h2>
                        </div>
                        <div class="row-2">
                            <div class="form-row">
                                <label>Description <span>*</span></label>
                                <input type="text" name="description" x-model="description">
                                <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="form-row">
                                <label>Pick date <span>*</span></label>
                                <input type="date" name="noted_date" x-model="noted_date">
                                <?php $__errorArgs = ['noted_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="form-button">
                            <button type="submit" color="primary" @click="onCreateStudyNote(<?php echo e($data->id); ?>, student_id)">
                                <i data-feather="save"></i>
                                <span>Submit</span>
                            </button>
                            <button color="danger" type="button" @click="createStudyNote=false">
                                <i data-feather="x"></i>
                                <span>Cancel</span>
                            </button>
                        </div>
                        <div class="row">
                            <h3 class="mb-0">
                                <?php echo e(strtoupper('study note event record')); ?>

                            </h3>
                            <div class="table">
                                <div class="table-wrapper">
                                    <div class="table-header bg-black text-light">
                                        <div class="row table-row-10">
                                            <span class="font-sm">N°</span>
                                        </div>
                                        <div class="row table-row-20">
                                            <span class="font-sm"><?php echo strtoupper('Date'); ?></span>
                                        </div>
                                        <div class="row table-row-70">
                                            <span class="font-sm"><?php echo strtoupper('Description'); ?></span>
                                        </div>
                                    </div>
                                    <div class="table-body  overflow-auto">
                                        <template x-for="(data, index) in student_notes">
                                            <div class="column">
                                                <div class="row table-row-10">
                                                    <span class="font-sm" x-text="index + 1"></span>
                                                </div>
                                                <div class="row table-row-20">
                                                    <span class="font-sm" x-text="data.noted_date"></span>
                                                </div>
                                                <div class="row table-row-70 text left">
                                                    <span class="font-sm" x-text="data.description"></span>
                                                </div>
                                            </div>
                                        </template>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</template><?php /**PATH /home/1051036.cloudwaysapps.com/bffmptmecd/public_html/resources/admin/views/pages/class/view-info/modal/create-study-note.blade.php ENDPATH**/ ?>