<div id="study-intern" class="form-body p-3 mt-3">
    <h2>
        <?php echo strtoupper('Student study intern'); ?>

    </h2>
    <div class="row">
        <div class="form-row flex-row">
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('student-intern-place-view')): ?>
            <button class="btn-create bg-primary mr-2 w-100 m-0"
                s-click-link="<?php echo e(route('admin-assign-internship-place-listing', request('id'))); ?>">
                <span class="w-100"><?php echo strtoupper('Manage intern place'); ?></span>
            </button>
            <?php endif; ?>
        </div>
    </div>
    <div class="row">
        <div class="table">
            <div class="table-wrapper">
                <div class="table-header bg-black text-light">
                    <div class="row table-row-10">
                        <span class="font-sm"><?php echo strtoupper('student id'); ?></span>
                    </div>
                    <div class="row table-row-15">
                        <span class="font-sm"><?php echo strtoupper('Name'); ?></span>
                    </div>
                    <div class="row table-row-15">
                        <span class="font-sm"><?php echo strtoupper('internship place'); ?></span>
                    </div>
                    <div class="row table-row-20">
                        <span class="font-sm"><?php echo strtoupper('location'); ?></span>
                    </div>
                    <div class="row table-row-15">
                        <span class="font-sm"><?php echo strtoupper('phone number'); ?></span>
                    </div>
                    <div class="row table-row-10">
                        <span class="font-sm"><?php echo strtoupper('register date'); ?></span>
                    </div>

                    <div class="row table-row-10">
                        <span class="font-sm"><?php echo strtoupper('interned status'); ?></span>
                    </div>
                    <div class="row table-row-5">
                        <span class="font-sm"></span>
                    </div>
                </div>
                <div class="table-body overflow-visible">
                    <?php $__currentLoopData = $student_intern->sortBy('student_id'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="column">
                        <div class="row table-row-10">
                            <span class="font-sm">
                                <?php echo e($item->student_id ?? '--'); ?>

                            </span>
                        </div>
                        <div class="row table-row-15">
                            <span class="font-sm">
                                <?php echo e($item->student->name_khmer ?? '--'); ?>

                            </span>
                        </div>
                        <div class="row table-row-15">
                            <span class="font-sm">
                                <?php echo e($item->internship_place->place_name ?? '--'); ?>

                            </span>
                        </div>
                        <div class="row table-row-20">
                            <span class="font-sm">
                                <?php echo e($item->internship_place->location ?? '--'); ?>

                            </span>
                        </div>
                        <div class="row table-row-15">
                            <span class="font-sm">
                                <?php echo e($item->internship_place->contact_number ?? '--'); ?>

                            </span>
                        </div>
                        <div class="row table-row-10">
                            <span class="font-sm">
                                <?php echo e($item->start_date ?? '--'); ?>

                            </span>
                        </div>
                        <div class="row table-row-10">
                            <span class="font-sm <?php echo e($item->is_intern_pass == 1 ? 'text-success' : 'text-danger'); ?>">
                                <?php echo e($item->is_intern_pass == 1
                                ? 'Passed'
                                : 'Failed'); ?>

                            </span>
                        </div>
                        <div class="row table-row-5">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['student-intern-place-update'])): ?>
                            <div class="dropdown">
                                <i data-feather="more-vertical" class="action-btn" id="dropdownMenuButton"
                                    data-mdb-toggle="dropdown" aria-expanded="false">
                                </i>
                                <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                    <?php if($item->is_intern_pass == 0): ?>
                                    <li>
                                        <a class="dropdown-item enable-btn" onclick="$onConfirmMessage(
                                                                '<?php echo route('admin-assign-internship-place-status', ['id' => $item->id, 'status' => 1]); ?>',
                                                                'Do you want to let <?php echo e($item->student->name_khmer); ?> pass internship?',
                                                                {
                                                                    confirm: '<?php echo app('translator')->get('dialog.button.ok'); ?>',
                                                                    cancel: '<?php echo app('translator')->get('dialog.button.cancel'); ?>'
                                                                },
                                                            );">
                                            <i data-feather="rotate-ccw"></i>
                                            <span>Assign to Pass</span>
                                        </a>
                                    </li>
                                    <?php else: ?>
                                    <li>
                                        <a class="dropdown-item disable-btn" onclick="$onConfirmMessage(
                                                                '<?php echo route('admin-assign-internship-place-status', ['id' => $item->id, 'status' => 0]); ?>',
                                                                'Do you want to let <?php echo e($item->student->name_khmer); ?> fail internship?',
                                                                {
                                                                    confirm: '<?php echo app('translator')->get('dialog.button.ok'); ?>',
                                                                    cancel: '<?php echo app('translator')->get('dialog.button.cancel'); ?>'
                                                                }
                                                            );">
                                            <i data-feather="rotate-ccw"></i>
                                            <span>Assign to Fail</span>
                                        </a>
                                    </li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</div><?php /**PATH /home/1051036.cloudwaysapps.com/bffmptmecd/public_html/resources/admin/views/pages/class/view-info/study-intern.blade.php ENDPATH**/ ?>