<?php $__env->startSection('layout'); ?>
    <div class="content-wrapper" x-data="student">
        <div class="header">
            <?php echo $__env->make('admin::shared.header', ['header_name' => 'Student Management'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="header-tab">
                <div class="header-tab-wrapper">
                    <div class="menu-row">
                        <div class="menu-item <?php echo Request::is('admin/student/list/1') ? 'active' : ''; ?>" s-click-link="<?php echo route('admin-student-list', 1); ?>">
                            Active
                        </div>
                        <div class="menu-item <?php echo Request::is('admin/student/list/2') ? 'active' : ''; ?>" s-click-link="<?php echo route('admin-student-list', 2); ?>">
                            <?php echo app('translator')->get('user.tab.disable'); ?>
                        </div>
                        <div class="menu-item <?php echo Request::is('admin/student/list/request_approval') ? 'active' : ''; ?>" s-click-link="<?php echo route('admin-student-list', 'request_approval'); ?>">
                            Request Approval
                        </div>
                    </div>
                </div>
                <div class="header-action-button">
                    <form class="filter" action="<?php echo url()->current(); ?>" method="GET">
                        <div class="form-row">
                            <select name="education_level" class="bg-transparent" style="width: 100%;">
                                <option value="">Select Education Level</option>
                                <?php $__currentLoopData = $education_levels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($item->id); ?>"
                                        <?php echo e(request('education_level') == $item->id ? 'selected' : ''); ?>><?php echo e($item->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-row">
                            <input type="text" name="keyword" placeholder="<?php echo app('translator')->get('user.filter.search'); ?>"
                                value="<?php echo request('keyword'); ?>">
                            <i data-feather="filter"></i>
                        </div>
                        <button mat-flat-button type="submit" class="btn-create bg-success">
                            <i data-feather="search"></i>
                            <span>Search</span>
                        </button>
                    </form>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('student-create')): ?>
                        <button class="btn-create" s-click-link="<?php echo route('admin-student-create'); ?>">
                            <i data-feather="plus-circle"></i>
                            <span>Create New Student</span>
                        </button>
                    <?php endif; ?>
                    <button s-click-link="<?php echo route('admin-student-export-excel', ['id' => request('id'), 'education_level' => request('education_level'), 'keyword' => request('keyword')]); ?>">
                        <i data-feather="download"></i>
                        <span>Excel</span>
                    </button>
                    <button s-click-link="<?php echo url()->current(); ?>">
                        <i data-feather="refresh-ccw"></i>
                        <span>Reload</span>
                    </button>
                </div>
            </div>
        </div>
        <div class="content-body">
            <?php echo $__env->make('admin::pages.student.table', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php echo $__env->make('admin::pages.student.study-background', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        Alpine.data('student', () => ({

            init() {

            },
            openStudyBackgroundDialog(data) {
                this.$store.studyBackgroundDialog.open({
                    data: data,
                    afterClosed: (res) => {
                        if (res) {
                            this.table.reload();
                        }
                    }
                });
            },
        }));
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin::shared.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/1051036.cloudwaysapps.com/bffmptmecd/public_html/resources/admin/views/pages/student/index.blade.php ENDPATH**/ ?>