
<?php $__env->startSection('layout'); ?>
<div class="form-admin">
    <div class="form-bg"></div>
    <form id="form" class="form-wrapper" action="<?php echo route('admin-cover-save', ['type' => 'about']); ?>" method="POST"
        enctype="multipart/form-data">
        <div class="form-header">
            <h3>
                About's Cover
            </h3>
        </div>
        <?php echo e(csrf_field()); ?>

        <div class="form-body">
            <div class="row">
                <div class="form-row">
                    <label>Image</label>
                    <div class="form-select-photo image">
                        <div class="select-photo <?php echo $data && isset($data) && $data->image != null ? 'active' : ''; ?>">
                            <div class="icon">
                                <i data-feather="image"></i>
                            </div>
                            <div class="title">
                                <span><?php echo app('translator')->get('user.form.profile.placeholder'); ?></span>
                            </div>
                        </div>
                        <div class="image-view <?php echo $data && isset($data) && $data->image != null ? 'active' : ''; ?>">
                            <img src="<?php echo $data && isset($data) && $data->image != null ? asset('file_manager' . $data->image) : null; ?>"
                                onerror="(this).src='<?php echo e(asset('images/logo/default.png')); ?>'" alt="">
                        </div>
                        <input type="text" name="image" s-click-fn="selectImage(event)" autocomplete="off"
                            value="<?php echo $data && isset($data) && $data->image != null ? $data->image : ''; ?>"
                            role="presentation">
                        <input type="hidden" name="tmp_file"
                            value="<?php echo $data && isset($data) && $data->image != null ? $data->image : ''; ?>">
                    </div>
                </div>
            </div>
            <div class="form-button">
                <button type="submit" color="primary">
                    <i data-feather="save"></i>
                    <span>Submit</span>
                </button>
            </div>
        </div>
        <div class="form-footer"></div>
    </form>
</div>
<?php echo $__env->make('admin::file-manager.popup', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script>
    $(document).ready(function() {
        $validator("#form", {
            image: {
                required: true,
            },
        });
    });
    function selectImage(e) {
            fileManager({
                multiple: false,
                afterClose: (data, basePath) => {
                    if (data?.length > 0) {
                        const parent = e.target.closest('.form-select-photo');
                        e.target.value = data[0].path;
                        parent
                            .querySelector('.select-photo')
                            .classList.add('active');
                        parent
                            .querySelector('.image-view')
                            .classList
                            .add('active');
                        parent
                            .querySelector('.image-view')
                            .childNodes[0]
                            .nextElementSibling
                            .setAttribute('src', basePath + data[0].path);
                    }
                }
            })
        }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin::shared.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/1051036.cloudwaysapps.com/bffmptmecd/public_html/resources/admin/views/pages/about/cover.blade.php ENDPATH**/ ?>