<div id="attendance" class="form-body p-3 mt-3">
    <h2>
        <?php echo strtoupper('Attendance list'); ?>

    </h2>
    <div class="row">
        <div class="form-row flex-row m-0 align-items-center">
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('attendance-print')): ?>
            <form class="d-flex align-items-center border-1-gray p-4 mr-2"
                action="<?php echo e(route('admin-printing-attendance-date', request('id'))); ?>" method="GET">
                <label for="date">Select Date</label>
                <input type="date" name="date" id="date" class="mr-2 border-1-gray p-2 text-gray-400">
                <button class="btn-create bg-primary mr-2" s-click-link="">
                    <i data-feather="printer"></i>
                    <span><?php echo strtoupper('Print attendane student'); ?></span>
                </button>
            </form>
            <button class="btn-create bg-primary mr-2"
                s-click-link="<?php echo e(route('admin-printing-attendance', ['id' => $data->id, 'about'=> false])); ?>">
                <i data-feather="printer"></i>
                <span><?php echo strtoupper('print current attendace record'); ?></span>
            </button>
            <?php endif; ?>
        </div>
    </div>
    <div class="row">
        <div class="table">
            <div class="table-wrapper">
                <div class="table-header bg-black text-light">
                    <div class="row table-row-10">
                        <span class="font-sm"><?php echo strtoupper('student ID'); ?></span>
                    </div>
                    <div class="row table-row-15">
                        <span class="font-sm"><?php echo strtoupper('Student name'); ?></span>
                    </div>
                    <div class="row table-row-20">
                        <span class="font-sm"><?php echo strtoupper('today attend: [').$today.']'; ?></span>
                    </div>
                    <div class="row table-row-15">
                        <span class="font-sm"><?php echo strtoupper('attend amount'); ?></span>
                    </div>
                    <div class="row table-row-10">
                        <span class="font-sm"><?php echo strtoupper('attend sum'); ?></span>
                    </div>
                    <div class="row table-row-10">
                        <span class="font-sm"><?php echo strtoupper('attend. %'); ?></span>
                    </div>
                    <div class="row table-row-10">
                        <span class="font-sm"><?php echo strtoupper('att. status'); ?></span>
                    </div>
                    <div class="row table-row-10">
                        <span class="font-sm"><?php echo strtoupper('action'); ?></span>
                    </div>
                </div>
                <div class="table-body overflow-auto">
                    <?php $__currentLoopData = $attendance_status->sortBy('student_id'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="column">
                        <div class="row table-row-10">
                            <span><?php echo $item->student_id ? $item->student_id : '--'; ?></span>
                        </div>
                        <div class="row table-row-15">
                            <span><?php echo $item->student->name_khmer ? $item->student->name_khmer : '--'; ?></span>
                        </div>
                        <div class="row table-row-20">
                            <span class="font-sm <?php echo isset($today_attend->student_id) ? in_array($item->student_id,
                                $today_attend->student_id) ? 
                                'text-success' : 
                                'text-danger' : 
                                'text-danger'; ?>">
                                <?php echo isset($today_attend->student_id) ? in_array($item->student_id,
                                $today_attend->student_id) ? 'YES' : 'NO' : 'NO'; ?></span>
                        </div>
                        <div class="row table-row-15">
                            <span class="font-sm">
                                <?php echo e($item->attend_amount ?? '--'); ?>

                            </span>
                        </div>
                        <div class="row table-row-10">
                            <span class="font-sm"><?php echo ($item->attend_amount ?? '--') .'/'.($total_attendance ?? '--'); ?></span>
                        </div>
                        <div class="row table-row-10">
                            <span class="font-sm"><?php echo e(($item->attend_percent ?? '--')); ?>.00 %</span>
                        </div>
                        <div class="row table-row-10">
                            <?php if( ($item->attend_percent ?? '--') > 49): ?>
                            <span class="text-success">
                                PASSED
                            </span>
                            <?php else: ?>
                            <span class="text-danger">
                                FAILED
                            </span>
                            <?php endif; ?>
                        </div>
                        <div class="row table-row-10 h-100 d-flex justify-content-center align-items-center">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('attendance-view-info')): ?>
                            <span class="font-sm h-50">
                                <button class="btn-create bg-primary h-100"
                                    @click="dialogStudentAttendance(<?php echo e($item->student_id); ?>, <?php echo e(request('id')); ?>)">
                                    <span><?php echo strtoupper('Detail'); ?></span>
                                </button>
                            </span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
    <?php echo $__env->make('admin::pages.class.view-info.modal.student-attendance', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div><?php /**PATH /home/1051036.cloudwaysapps.com/bffmptmecd/public_html/resources/admin/views/pages/class/view-info/attendance.blade.php ENDPATH**/ ?>