
<?php $__env->startSection('content'); ?>
    <!-- Course -->
    <?php if(isset($courses) && count($courses) > 0): ?>
        <div class="container course-page  bg-black" x-data="courseDialog">
            <div class="course-header-wrapper">
                <div class="border-wrapper">
                    <div class="border" style="border-bottom: 1px solid yellow"></div>
                    <h3 class="text-3xl text-yellow-500">Course</h3>
                    <div class="border" style="border-bottom: 1px solid yellow"></div>
                </div>
            </div>
            <div class="course-page-wrapper gap-x-8 gap-y-1 mt-5">
                <!-- register-content -->
                <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="course-page-wrapper-box p-2 register-content !w-full" id="register-content"
                        data-aos="fade-up" data-aos-duration="3000" x-data="{ show: true }">

                        <!-- course-content -->
                        <div class="course-content" x-show="show == true">
                            <div class="image-course w-1/2 ">
                                <img src="<?php echo e(asset('file_manager' . $item?->image)); ?>" alt=""
                                    onerror="this.onerror=null;this.src='<?php echo e(asset('website/images/logo/default.png')); ?>';">
                                <div class="btn-register">
                                    <button class="uppercase" @click="openRegisterDialog('<?php echo e($item); ?>')">Register
                                        Now</button>
                                </div>
                            </div>
                            <div class="detail-course w-1/2 ">
                                <h2>
                                    <?php echo e($item?->name); ?>

                                </h2>
                                <p>
                                    <?php echo e($item?->description); ?>

                                </p>
                                <div class="dates mt-5">
                                    <span class="flex flex-row  space-x-2">
                                        <i class="fas fa-calendar-alt text-yellow-500"></i>
                                        <span><?php echo e(date('d-M-Y', strtotime($item?->created_at))); ?></span>
                                    </span>
                                </div>
                                <div class="day mb-2">
                                    <span class="flex flex-row space-x-2">
                                        <i class="far fa-calendar-check"></i>
                                        <h6><?php echo e($item?->duration); ?> day(s)</h6>
                                    </span>
                                </div>
                                <div class="price">
                                    <h3><?php echo e($item?->fee); ?></h3>
                                </div>
                                <div class="btn-trainer" id="btn-trainer">
                                    <button class="uppercase" @click="show = false">Trainer</button>
                                </div>
                            </div>
                        </div>

                        <!-- trainer-content -->
                        <div class="course-content" x-show="show == false">
                            <div class="cart mt-5">
                                <div class="text-cart">
                                    <div class="title">
                                        <h4 class="text-yellow-600"><?php echo e(optional($item?->trainer)?->name); ?></h4>
                                    </div>
                                    <div class="text">
                                        <div class="flex flex-col">
                                            <div class="flex flex-row space-x-2">
                                                <p>Experience: </p>
                                                <p><?php echo e(optional($item?->trainer)?->experience); ?> year(s)</p>
                                            </div>
                                        </div>
                                        <div class="flex flex-col">
                                            <div class="flex flex-row space-x-14">
                                                <p>Skill: </p>
                                                <p><?php echo e(optional($item?->trainer)->skill); ?></p>
                                            </div>
                                        </div>
                                        <div class="flex flex-col">
                                            <div class="flex flex-row space-x-12">
                                                <p>Work: </p>
                                                <p><?php echo e(optional($item?->trainer)->work); ?></p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="btn-trainer btn-course" id="btn-course">
                                        <button class="uppercase" @click="show = true">Course</button>
                                    </div>
                                </div>
                            </div>
                            <div class="image-course w-1/2 ">
                                <img src="<?php echo e(asset('file_manager' . $item?->image)); ?>" alt="">
                                <div class="btn-register">
                                    <button class="uppercase" @click="openRegisterDialog('<?php echo e($item); ?>')">Register
                                        Now</button>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <?php echo $__env->make('website::components.register-dialog', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>


        <?php echo $__env->make('website::components.pagination', ['data' => $courses], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php else: ?>
        <?php $__env->startComponent('website::components.empty', [
            'title' => __('Empty Data'),
            'message' => __('No data found for this search'),
            'image' => asset('images/empty.svg'),
            'style' => 'height: 300px; width: auto;',
        ]); ?>
        <?php echo $__env->renderComponent(); ?>
    <?php endif; ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        Alpine.data("courseDialog", () => ({
            isActive: 'course',

            switchToActive(type) {
                this.isActive = type
            },

            openRegisterDialog(data) {
                this.$store.registerDialog.open({
                    data: {
                        data: data
                    }
                })
            }
        }));
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('shared.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/1051036.cloudwaysapps.com/bffmptmecd/public_html/resources/website/views/pages/course/search.blade.php ENDPATH**/ ?>