<div class="dialog" x-data="confirmDeleteDialog">
    <div class="dialog-container">
        <form class="dialog-form" id="dialog-form" style="width: 300px" @submit.prevent>
            <div class="dialog-form-header">
                <h3><?php echo app('translator')->get('file-manager.delete-file.title'); ?></h3>
            </div>
            <div class="dialog-form-body">
                <div class="form-row">
                    
                    <template x-if="!data?.delete_all">
                        <p><?php echo app('translator')->get('file-manager.delete-file.confirm'); ?> <b
                                x-text="deleteFiles?.length+' files and folders'"></b>?</p>
                    </template>
                    <template x-if="data?.delete_all">
                        <p><?php echo app('translator')->get('file-manager.delete-file.confirm'); ?> <b>All files and folders</b>?</p>
                    </template>
                </div>
            </div>
            <div class="dialog-form-footer">
                <button type="button" class="close"
                    @click="onClose()"><?php echo app('translator')->get('file-manager.delete-file.button.cancel'); ?></button>
                <button type="button" @click="onSave()"
                    x-bind:disabled="form.disabled && form.loading"><?php echo app('translator')->get('file-manager.delete-file.button.delete'); ?>
                    <div class="loader" style="display: none" x-show="form.disabled && form.loading"></div>
                </button>
            </div>
        </form>
    </div>
    <script>
        Alpine.data('confirmDeleteDialog', () => ({
            data: null,
            deleteFiles: [],
            form: {
                value: {},
                validate_message: {},
                loading: false,
                disabled: false,
            },
            init() {
                this.data = this.dialog.data['confirmDeleteDialog'];
                this.deleteFiles = this.data.contentMenu?.show ? [this.data.contentMenu?.data] : this.data
                    .selected_files;
                Alpine.store('animate').enter(this.$root.children[0], () => {
                    this.closeContextMenu();
                });
            },
            onClose(data = null) {
                Alpine.store('animate').leave(this.$root.children[0], () => {
                    this.dialog.close('confirmDeleteDialog', data);
                });
            },
            onSave() {
                this.form.loading = true;
                this.form.disabled = true;
                Axios.delete(`<?php echo e(route('admin-file-manager-delete-all')); ?>`, {
                    data: {
                        all: this.data.delete_all || '',
                        data: this.deleteFiles,
                    }
                }).then((response) => {
                    this.onClose(response.data);
                }).catch(error => {
                    this.form.loading = false;
                    this.form.disabled = false;
                });
            }
        }));
    </script>
</div>
<?php /**PATH /home/1051036.cloudwaysapps.com/bffmptmecd/public_html/resources/admin/views/file-manager/confirm-delete-dialog.blade.php ENDPATH**/ ?>