
<?php $__env->startSection('content'); ?>
    <!-- About page -->
    <?php if(isset($about)): ?>
        <div class="about-us-section">
            <div class="about-us-section-slide">
                <div class="slide-img">
                    <img src="<?php echo e(asset('file_manager' . $cover?->image)); ?>" alt="" onerror="this.onerror=null;this.src='<?php echo e(asset('website/images/logo/default.png')); ?>';">
                </div>

                <div class="overview">
                    <div class="overview-contain container">
                        <div class="left-overview">
                            <div class="border-wrapper">
                                <div class="border" style="border-bottom: 1px solid yellow"></div>
                                <h3 class="text-3xl text-yellow-500">OVERVIEW</h3>
                                <div class="border" style="border-bottom: 1px solid yellow"></div>
                            </div>
                            <div class="text" data-aos="fade-right">
                                <p>
                                    <?php echo e($about?->description); ?>

                                </p>
                            </div>
                        </div>
                        <div class="right-overview">
                            <div class="right-img" data-aos="fade-left">
                                <img src="<?php echo e(asset('file_manager' . $about?->image)); ?>" alt="" onerror="this.onerror=null;this.src='<?php echo e(asset('website/images/logo/default.png')); ?>';">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="map-contain container">
                    <div class="contain-about-us flex flex-row justify-between space-x-5">
                        <?php if(isset($contact)): ?>
                            <div class="left-contain">
                                <div class="left-contain-text flex flex-row space-x-3 aos-init aos-animate"
                                    data-aos="fade-up">
                                    <i class="fas fa-map-marker-alt text-yellow-500"></i>
                                    <p class="text-white">
                                        <?php echo e($contact?->address); ?>

                                    </p>
                                </div>
                                <div class="left-contain-text flex flex-row space-x-3 aos-init aos-animate"
                                    data-aos="fade-up">
                                    <i class="fas fa-phone text-yellow-500"></i>
                                    <p class="text-sm text-white">
                                        <?php echo e($contact?->phone); ?>

                                    </p>
                                </div>
                                <div class="map aos-init aos-animate" data-aos="fade-right">
                                    <iframe src="<?php echo e(getMapEmbedSrc($contact?->google_map)); ?>" width="600" height="450"
                                        style="border:0;" allowfullscreen="" loading="lazy"
                                        referrerpolicy="no-referrer-when-downgrade"></iframe>
                                </div>
                            </div>
                        <?php endif; ?>
                        <?php if(isset($workDay) && count($workDay) > 0): ?>
                            <div class="right-contain mt-10">
                                <div class="right-contain-title text-white text-center">
                                    <h3 class="text-lg font-semibold">OPENING HOURS</h3>
                                    <div class="open-hour py-8 px-14">
                                        <?php $__currentLoopData = $workDay; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="hour flex flex-row py-2 px-8 justify-between aos-init aos-animate"
                                                data-aos="fade-left">
                                                <p><?php echo e($item?->day); ?></p>
                                                <p>
                                                    <?php echo e(\carbon\Carbon::parse($item?->from_hour)->format('H:i A')); ?>

                                                    - 
                                                    <?php echo e(\carbon\Carbon::parse($item?->to_hour)->format('H:i A')); ?>

                                                </p>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Mission & Vison -->
                <?php if(isset($about)): ?>
                    <div class="mission-section container mt-20">
                        <div class="mission-section-group">
                            <div class="mission border-r-2 border-white">
                                <div class="border-wrapper" data-aos="fade-right">
                                    <div class="border" style="border-bottom: 1px solid rgb(255, 174, 0)"></div>
                                    <h3 class="text-3xl text-yellow-500 uppercase">Mission</h3>
                                    <div class="border" style="border-bottom: 1px solid rgb(255, 174, 0)"></div>
                                </div>
                                <p class="text-white text-base pr-6 text-center" data-aos="fade-right">
                                    <?php echo e($about?->mission); ?>

                                </p>
                            </div>
                            <div class="vision px-8">
                                <div class="border-wrapper" data-aos="fade-left">
                                    <div class="border" style="border-bottom: 1px solid rgb(255, 174, 0)"></div>
                                    <h3 class="text-3xl text-yellow-500 uppercase">Vision</h3>
                                    <div class="border" style="border-bottom: 1px solid rgb(255, 174, 0)"></div>
                                </div>
                                <p class="text-white text-base text-center" data-aos="fade-left">
                                    <?php echo e($about?->vision); ?>

                                </p>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
                <!-- aboutHistory -->
                <?php if(isset($aboutHistory) && count($aboutHistory) > 0): ?>
                    <div class="container about-history bg-black">
                        <div class="about-history-wrapper">
                            <?php $__currentLoopData = $aboutHistory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="about-history-box">
                                    <div class="about-history-box-img">
                                        <img src="<?php echo e(asset('file_manager' . $item?->image)); ?>" alt="">
                                    </div>
                                    <div class="about-history-box-text">
                                        <div class="flex flex-row justify-between items-center space-x-5 mb-5">
                                            <div>
                                                <h3 class="text-3xl text-yellow-500 font-semibold">
                                                    <?php echo e($item?->title); ?>

                                                </h3>
                                            </div>
                                            <div class="single-line"></div>
                                        </div>
                                        <p class="text-white">
                                            <?php echo e($item?->description); ?>

                                        </p>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    <?php else: ?>
        <?php $__env->startComponent('website::components.empty', [
            'title' => __('Empty Data'),
            'message' => __('No Data in this Page'),
            'image' => asset('images/empty.svg'),
            'style' => 'height: 300px; width: auto;',
        ]); ?>
        <?php echo $__env->renderComponent(); ?>
    <?php endif; ?>
    <!-- space -->
    <div class="space"></div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('shared.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/1051036.cloudwaysapps.com/bffmptmecd/public_html/resources/website/views/pages/about.blade.php ENDPATH**/ ?>