<div class="form-body w-50 border-1-gray p-2" style="margin-right: 5px;">
    <div>
        <h2 class="mt-0"><?php echo e(strtoupper('Exam Subject List')); ?></h3>
    </div>
    <div class="mb-3">
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('exam-subject-create')): ?>
        <span class="h-50">
            <button class="btn-create bg-primary h-100" @click="dialogOpenCreateESubject()">
                <span><?php echo strtoupper('add new exam subject'); ?></span>
            </button>
        </span>
        <?php endif; ?>
    </div>
    <div>
        <span>
            Exam id: <span x-text="exam_detail_id"></span>
        </span>
    </div>
    <div class="table">
        <div class="table-wrapper">
            <div class="table-header bg-black text-light">
                <div class="row table-row-15">
                    <span class="font-sm"><?php echo e(strtoupper('subject id')); ?></span>
                </div>
                <div class=" row table-row-40">
                    <span class="font-sm"><?php echo e(strtoupper('subject name')); ?></span>
                </div>
                <div class=" row table-row-40">
                    <span class="font-sm"><?php echo e(strtoupper('issuer name')); ?></span>
                </div>
                <div class=" row table-row-5">
                </div>
            </div>
            <div class="table-body h-auto overflow-visible">
                <template x-if="exam_subject.length > 0">
                    <template x-for="data in exam_subject">
                        <div class="column">
                            <div class="row table-row-15">
                                <span class="font-sm" x-text="data.id"></span>
                            </div>
                            <div class="row table-row-40">
                                <span class="font-sm" x-text="data.description"></span>
                            </div>
                            <div class="row table-row-40">
                                <span class="font-sm" x-text="data.staff.full_name"></span>
                            </div>
                            <div class="row table-row-5">
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['exam-subject-update', 'exam-subject-destroy', 'exam-subject-view-info'])): ?>
                                <div class="dropdown">
                                    <i data-feather="more-vertical" class="action-btn" id="dropdownMenuButton"
                                        data-mdb-toggle="dropdown" aria-expanded="false">
                                    </i>
                                    <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                        <?php if(1==1): ?>
                                        <template x-if="data.google_doc_url != null">
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('exam-subject-view-info')): ?>
                                            <li>
                                                <a class="dropdown-item" :href="data.google_doc_url" target="_blank">
                                                    <i data-feather="file-text"></i>
                                                    <span>View Doc</span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                        </template>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('exam-subject-update')): ?>
                                        <li>
                                            <a class="dropdown-item" @click="dialogOpenUpdateESubject(data.id)">
                                                <i data-feather="edit"></i>
                                                <span>Edit</span>
                                            </a>
                                        </li>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('exam-subject-destroy')): ?>
                                        <li>
                                            <a class="dropdown-item disable-btn" @click="onConfirmMessageES(data)">
                                                <i data-feather="trash-2"></i>
                                                <span>Delete</span>
                                            </a>
                                        </li>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('exam-subject-to-score')): ?>
                                        <li @click="dialogToScore(data.id)">
                                            <a class="dropdown-item disable-btn">
                                                <i data-feather="check-square"></i>
                                                <span>To Score</span>
                                            </a>
                                        </li>
                                        <?php endif; ?>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </template>
                </template>
                <template x-if="exam_subject.length < 1">
                    <div class="column">
                        <div class="row table-row-100">
                            <span class="font-sm text-danger font-weight-bolder"><?php echo e(strtoupper('No data!')); ?></span>
                        </div>
                    </div>
                </template>
            </div>
        </div>
    </div>
</div><?php /**PATH /home/1051036.cloudwaysapps.com/bffmptmecd/public_html/resources/admin/views/pages/examControl/examSubject/index.blade.php ENDPATH**/ ?>