<div class="table">
    <?php if($data->count() > 0): ?>
        <div class="table-wrapper">
            <div class="table-header">
                <div class="row table-row-5">
                    <span><?php echo app('translator')->get('table.field.no'); ?></span>
                </div>
                <div class="row table-row-10">
                    <span><?php echo app('translator')->get('table.field.profile'); ?></span>
                </div>
                <div class="row table-row-15">
                    <span>Name Lating</span>
                </div>
                <div class="row table-row-15">
                    <span>Name Khmer</span>
                </div>
                <div class="row table-row-10">
                    <span>Student ID</span>
                </div>
                <div class="row table-row-15">
                    <span>Education</span>
                </div>
                <div class="row table-row-15">
                    <span><?php echo app('translator')->get('table.field.phone'); ?></span>
                </div>
                <div class="row table-row-10">
                    <span>Approval Status</span>
                </div>
                <div class="row table-row-5">
                    <span></span>
                </div>
            </div>
            <div class="table-body">
                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="column">
                        <div class="row table-row-5">
                            <span><?php echo $data->currentPage() * $data->perPage() - $data->perPage() + ($index + 1); ?></span>
                        </div>
                        <div class="row table-row-10">
                            <div class="thumbnail" data-fancybox
                                data-src="<?php echo e(asset('file_manager' . $item->profile)); ?>">
                                <img style="object-fit: contain" src="<?php echo $item->profile != null ? asset('file_manager' . $item->profile) : asset('images/logo/default.png'); ?>"
                                    onerror="(this).src='<?php echo e(asset('images/logo/default.png')); ?>'" alt="">
                            </div>
                        </div>
                        <div class="row table-row-15">
                            <span><?php echo e($item->name_latin ?? '--'); ?></span>
                        </div>
                        <div class="row table-row-15">
                            <span><?php echo e($item->name_khmer ?? '--'); ?></span>
                        </div>
                        <div class="row table-row-10">
                            <span><?php echo e($item->sid ?? '--'); ?></span>
                        </div>
                        <div class="row table-row-15">
                            <span><?php echo e($item?->education_level?->name); ?></span>
                        </div>
                        <div class="row table-row-15">
                            <span><?php echo e($item->phone); ?></span>
                        </div>
                        <div class="row table-row-10" style="text-transform: capitalize">
                            <span><?php echo e($item->approval_status ?? '--'); ?></span>
                        </div>
                        <div class="row table-row-5">
                            <?php if($item->approval_status != 'rejected'): ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['student-update', 'student-view-info', 'student-assign'])): ?>
                                    <div class="dropdown">
                                        <i data-feather="more-vertical" class="action-btn" id="dropdownMenuButton"
                                            data-mdb-toggle="dropdown" aria-expanded="false">
                                        </i>
                                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                            <?php if($item->approval_status == 'approved'): ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('student-view-info')): ?>
                                                    <li>
                                                        <a class="dropdown-item" s-click-link="<?php echo route('admin-student-view', $item->id); ?>">
                                                            <i data-feather="monitor"></i>
                                                            <span>View Info</span>
                                                        </a>
                                                    </li>
                                                <?php endif; ?>
                                                <?php if(count($item->classes)): ?>
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('student-view-info')): ?>
                                                        <li @click="openStudyBackgroundDialog('<?php echo e($item); ?>')">
                                                            <a class="dropdown-item">
                                                                <i data-feather="activity"></i>
                                                                <span>Study Background</span>
                                                            </a>
                                                        </li>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('student-update')): ?>
                                                    <li>
                                                        <a class="dropdown-item" s-click-link="<?php echo route('admin-student-create', $item->id); ?>">
                                                            <i data-feather="edit"></i>
                                                            <span><?php echo app('translator')->get('table.option.edit'); ?></span>
                                                        </a>
                                                    </li>
                                                    <?php if($item->status == 1): ?>
                                                        <li>
                                                            <a class="dropdown-item disable-btn"
                                                                onclick="$onConfirmMessage(
                                                                '<?php echo route('admin-student-status', ['id' => $item->id, 'status' => 2]); ?>',
                                                                '<?php echo app('translator')->get('dialog.msg.disable', ['name' => $item->name]); ?>',
                                                                {
                                                                    confirm: '<?php echo app('translator')->get('dialog.button.disable'); ?>',
                                                                    cancel: '<?php echo app('translator')->get('dialog.button.cancel'); ?>'
                                                                }
                                                            );">
                                                                <i data-feather="x-circle"></i>
                                                                <span>Disable</span>
                                                            </a>
                                                        </li>
                                                    <?php else: ?>
                                                        <li>
                                                            <a class="dropdown-item enable-btn"
                                                                onclick="$onConfirmMessage(
                                                                '<?php echo route('admin-student-status', ['id' => $item->id, 'status' => 1]); ?>',
                                                                '<?php echo app('translator')->get('dialog.msg.enable', ['name' => $item->name]); ?>',
                                                                {
                                                                    confirm: '<?php echo app('translator')->get('dialog.button.enable'); ?>',
                                                                    cancel: '<?php echo app('translator')->get('dialog.button.cancel'); ?>'
                                                                },
                                                            );">
                                                                <i data-feather="rotate-ccw"></i>
                                                                <span>Enable</span>
                                                            </a>
                                                        </li>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('student-assign')): ?>
                                                    <li>
                                                        <a class="dropdown-item" s-click-link="<?php echo route('admin-student-assign-class', $item->id); ?>">
                                                            <i data-feather="edit"></i>
                                                            <span>Assign Class</span>
                                                        </a>
                                                    </li>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('student-update')): ?>
                                                    <?php if($item->approval_status == 'pending'): ?>
                                                        <li>
                                                            <a class="dropdown-item disable-btn"
                                                                onclick="$onConfirmMessage(
                                                                '<?php echo route('admin-student-approval-status', ['id' => $item->id, 'approval_status' => 'rejected']); ?>',
                                                                'Are you sure you want to <b>reject</b> register student <b> <?php echo e($item->name_latin); ?> </b> ?',
                                                                {
                                                                    confirm: 'Reject',
                                                                    cancel: 'Close'
                                                                }
                                                            );">
                                                                <i data-feather="x"></i>
                                                                <span>Reject</span>
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a class="dropdown-item enable-btn"
                                                                onclick="$onConfirmMessage(
                                                                '<?php echo route('admin-student-approval-status', ['id' => $item->id, 'approval_status' => 'approved']); ?>',
                                                                'Are you sure you want to <b>approve</b> register student <b> <?php echo e($item->name_latin); ?> </b> ?',
                                                                {
                                                                    confirm: 'Approve',
                                                                    cancel: 'Close'
                                                                },
                                                            );">
                                                                <i data-feather="check"></i>
                                                                <span>Approve</span>
                                                            </a>
                                                        </li>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            <?php endif; ?>  
                                        </ul>
                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </div>
            <div class="table-footer">
                <?php echo $__env->make('admin::components.pagination', ['paginate' => $data], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>
    <?php else: ?>
        <?php $__env->startComponent('admin::components.empty', [
            'name' => 'Student is empty',
            'msg' => 'You can create a new Student by clicking the button below.',
            'permission' => 'student-create',
            'url' => route('admin-student-create'),
            'button' => 'Create New Student',
        ]); ?>
        <?php echo $__env->renderComponent(); ?>
    <?php endif; ?>
</div>
<?php /**PATH /home/1051036.cloudwaysapps.com/bffmptmecd/public_html/resources/admin/views/pages/student/table.blade.php ENDPATH**/ ?>